/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.unsafe.impl.batchimport.BatchingIdGetter;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.values.storable.Values;

abstract class EntityImporter
extends InputEntityVisitor.Adapter {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyTokenRepository;
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;
    private PropertyBlock[] propertyBlocks = new PropertyBlock[100];
    private int propertyBlocksCursor;
    private final BatchingIdGetter propertyIds;
    protected final DataImporter.Monitor monitor;
    private long propertyCount;
    private boolean hasPropertyId;
    private long propertyId;
    private final DynamicRecordAllocator dynamicStringRecordAllocator;
    private final DynamicRecordAllocator dynamicArrayRecordAllocator;

    protected EntityImporter(BatchingNeoStores stores, DataImporter.Monitor monitor) {
        this.propertyStore = stores.getPropertyStore();
        this.propertyKeyTokenRepository = stores.getPropertyKeyRepository();
        this.monitor = monitor;
        for (int i = 0; i < this.propertyBlocks.length; ++i) {
            this.propertyBlocks[i] = new PropertyBlock();
        }
        this.propertyRecord = this.propertyStore.newRecord();
        this.propertyIds = new BatchingIdGetter(this.propertyStore);
        this.dynamicStringRecordAllocator = new StandardDynamicRecordAllocator(new BatchingIdGetter(this.propertyStore.getStringStore(), this.propertyStore.getStringStore().getRecordsPerPage()), this.propertyStore.getStringStore().getRecordDataSize());
        this.dynamicArrayRecordAllocator = new StandardDynamicRecordAllocator(new BatchingIdGetter(this.propertyStore.getArrayStore(), this.propertyStore.getArrayStore().getRecordsPerPage()), this.propertyStore.getStringStore().getRecordDataSize());
    }

    @Override
    public boolean property(String key, Object value) {
        assert (!this.hasPropertyId);
        return this.property(this.propertyKeyTokenRepository.getOrCreateId(key), value);
    }

    @Override
    public boolean property(int propertyKeyId, Object value) {
        assert (!this.hasPropertyId);
        this.encodeProperty(this.nextPropertyBlock(), propertyKeyId, value);
        ++this.propertyCount;
        return true;
    }

    @Override
    public boolean propertyId(long nextProp) {
        assert (!this.hasPropertyId);
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return true;
    }

    @Override
    public void endOfEntity() {
        this.propertyBlocksCursor = 0;
        this.hasPropertyId = false;
    }

    private PropertyBlock nextPropertyBlock() {
        if (this.propertyBlocksCursor == this.propertyBlocks.length) {
            this.propertyBlocks = Arrays.copyOf(this.propertyBlocks, this.propertyBlocksCursor * 2);
            for (int i = this.propertyBlocksCursor; i < this.propertyBlocks.length; ++i) {
                this.propertyBlocks[i] = new PropertyBlock();
            }
        }
        return this.propertyBlocks[this.propertyBlocksCursor++];
    }

    private void encodeProperty(PropertyBlock block, int key, Object value) {
        PropertyStore.encodeValue(block, key, Values.of((Object)value), this.dynamicStringRecordAllocator, this.dynamicArrayRecordAllocator, this.propertyStore.allowStorePointsAndTemporal());
    }

    protected long createAndWritePropertyChain() {
        if (this.hasPropertyId) {
            return this.propertyId;
        }
        if (this.propertyBlocksCursor == 0) {
            return Record.NO_NEXT_PROPERTY.longValue();
        }
        PropertyRecord currentRecord = this.propertyRecord(this.propertyIds.next());
        long firstRecordId = currentRecord.getId();
        for (int i = 0; i < this.propertyBlocksCursor; ++i) {
            PropertyBlock block = this.propertyBlocks[i];
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                long nextPropertyId = this.propertyIds.next();
                long prevId = currentRecord.getId();
                currentRecord.setNextProp(nextPropertyId);
                this.propertyStore.updateRecord(currentRecord);
                currentRecord = this.propertyRecord(nextPropertyId);
                currentRecord.setPrevProp(prevId);
            }
            currentRecord.addPropertyBlock(block);
        }
        if (currentRecord.size() > 0) {
            this.propertyStore.updateRecord(currentRecord);
        }
        return firstRecordId;
    }

    protected abstract PrimitiveRecord primitiveRecord();

    private PropertyRecord propertyRecord(long nextPropertyId) {
        this.propertyRecord.clear();
        this.propertyRecord.setInUse(true);
        this.propertyRecord.setId(nextPropertyId);
        this.primitiveRecord().setIdTo(this.propertyRecord);
        this.propertyRecord.setCreated();
        return this.propertyRecord;
    }

    @Override
    public void close() {
        this.monitor.propertiesImported(this.propertyCount);
    }
}

