/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacheReader;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacheWriter;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputNodeCacheReader
extends InputEntityCacheReader {
    public InputNodeCacheReader(StoreChannel channel, StoreChannel header) throws IOException {
        super(channel, header);
    }

    @Override
    public InputChunk newChunk() {
        return new InputNodeDeserializer();
    }

    class InputNodeDeserializer
    extends InputEntityCacheReader.InputEntityDeserializer {
        protected String[] previousLabels;

        InputNodeDeserializer() {
            super(InputNodeCacheReader.this);
            this.previousLabels = InputEntityCacheWriter.EMPTY_STRING_ARRAY;
        }

        @Override
        public boolean next(InputEntityVisitor visitor) throws IOException {
            if (!this.readProperties(visitor)) {
                return false;
            }
            Group group = this.readGroup(0);
            Object id = this.readValue();
            visitor.id(id, group);
            byte labelsMode = this.channel.get();
            if (labelsMode == 3) {
                visitor.labelField(this.channel.getLong());
            } else if (labelsMode == 0) {
                visitor.labels(this.previousLabels);
            } else {
                String[] newLabels = (String[])this.previousLabels.clone();
                int cursor = newLabels.length;
                while (labelsMode != 0) {
                    switch (labelsMode) {
                        case 1: {
                            this.remove((String)this.readToken((byte)1), newLabels, cursor--);
                            break;
                        }
                        case 2: {
                            String[] stringArray = this.ensureRoomForOneMore(newLabels, cursor);
                            newLabels = stringArray;
                            stringArray[cursor++] = (String)this.readToken((byte)1);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unrecognized label mode " + labelsMode);
                        }
                    }
                    labelsMode = this.channel.get();
                }
                this.previousLabels = cursor == newLabels.length ? newLabels : Arrays.copyOf(newLabels, cursor);
                visitor.labels(this.previousLabels);
            }
            return true;
        }

        private String[] ensureRoomForOneMore(String[] labels, int cursor) {
            return cursor >= labels.length ? Arrays.copyOf(labels, cursor + 1) : labels;
        }

        private void remove(String item, String[] from, int cursor) {
            for (int i = 0; i < cursor; ++i) {
                if (!item.equals(from[i])) continue;
                from[i] = from[cursor - 1];
                from[cursor - 1] = null;
                return;
            }
            throw new IllegalArgumentException("Diff said to remove " + item + " from " + Arrays.toString(from) + ", but it didn't contain it");
        }
    }
}

