/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

class ConflictDetectingValueMerger<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
implements ValueMerger<KEY, VALUE> {
    private final boolean compareEntityIds;
    private boolean conflict;
    private long existingNodeId;
    private long addedNodeId;

    ConflictDetectingValueMerger(boolean compareEntityIds) {
        this.compareEntityIds = compareEntityIds;
    }

    public VALUE merge(KEY existingKey, KEY newKey, VALUE existingValue, VALUE newValue) {
        if (((NativeSchemaKey)((Object)existingKey)).getEntityId() != ((NativeSchemaKey)((Object)newKey)).getEntityId()) {
            this.conflict = true;
            this.existingNodeId = ((NativeSchemaKey)((Object)existingKey)).getEntityId();
            this.addedNodeId = ((NativeSchemaKey)((Object)newKey)).getEntityId();
        }
        return null;
    }

    void controlConflictDetection(KEY key) {
        ((NativeSchemaKey)((Object)key)).setCompareId(this.compareEntityIds);
    }

    void checkConflict(Value[] values) throws IndexEntryConflictException {
        if (this.conflict) {
            this.conflict = false;
            throw new IndexEntryConflictException(this.existingNodeId, this.addedNodeId, ValueTuple.of((Value[])values));
        }
    }
}

