/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;

public class RecoveryRequiredChecker {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final Monitors monitors;
    private Config config;

    public RecoveryRequiredChecker(FileSystemAbstraction fs, PageCache pageCache, Config config, Monitors monitors) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.config = config;
        this.monitors = monitors;
    }

    public boolean isRecoveryRequiredAt(File dataDir) throws IOException {
        if (!NeoStores.isStorePresent(this.pageCache, dataDir)) {
            return false;
        }
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> reader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(dataDir, this.fs, this.pageCache).withConfig(this.config).withLogEntryReader(reader).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, reader, this.monitors);
        return new RecoveryStartInformationProvider(tailScanner, RecoveryStartInformationProvider.NO_MONITOR).get().isRecoveryRequired();
    }
}

