/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;

class LocalTimeSchemaKey
extends NativeSchemaKey<LocalTimeSchemaKey> {
    static final int SIZE = 16;
    long nanoOfDay;

    LocalTimeSchemaKey() {
    }

    @Override
    public Value asValue() {
        return LocalTimeValue.localTime((long)this.nanoOfDay);
    }

    @Override
    public void initValueAsLowest() {
        this.nanoOfDay = Long.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest() {
        this.nanoOfDay = Long.MAX_VALUE;
    }

    @Override
    public int compareValueTo(LocalTimeSchemaKey other) {
        return Long.compare(this.nanoOfDay, other.nanoOfDay);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,nanoOfDay=%d", this.asValue(), this.getEntityId(), this.nanoOfDay);
    }

    @Override
    public void writeLocalTime(long nanoOfDay) {
        this.nanoOfDay = nanoOfDay;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof LocalTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support LocalTimeValue, tried to create key from " + value);
        }
        return value;
    }
}

