/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.neo4j.kernel.impl.index.schema.IndexPartsCache;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexCache<T>
extends IndexPartsCache<CoordinateReferenceSystem, T> {
    private final Factory<T> factory;

    SpatialIndexCache(Factory<T> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T uncheckedSelect(CoordinateReferenceSystem crs) {
        Object existing = this.cache.get(crs);
        if (existing != null) {
            return (T)existing;
        }
        this.instantiateCloseLock.lock();
        try {
            this.assertOpen();
            Object object = this.cache.computeIfAbsent(crs, key -> {
                try {
                    return this.factory.newSpatial(crs);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return (T)object;
        }
        finally {
            this.instantiateCloseLock.unlock();
        }
    }

    T select(CoordinateReferenceSystem crs) throws IOException {
        try {
            return this.uncheckedSelect(crs);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    <RESULT> RESULT selectOrElse(CoordinateReferenceSystem crs, Function<T, RESULT> function, RESULT orElse) {
        Object part = this.cache.get(crs);
        if (part == null) {
            return orElse;
        }
        return function.apply(part);
    }

    void loadAll() {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            this.uncheckedSelect(crs);
        }
    }

    static interface Factory<T> {
        public T newSpatial(CoordinateReferenceSystem var1) throws IOException;
    }
}

