/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final SchemaState schemaState;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;
    private final IndexProviderMap indexProviderMap;

    public TransactionToRecordStateVisitor(TransactionRecordState recordState, SchemaState schemaState, SchemaStorage schemaStorage, ConstraintSemantics constraintSemantics, IndexProviderMap indexProviderMap) {
        this.recordState = recordState;
        this.schemaState = schemaState;
        this.schemaStorage = schemaStorage;
        this.constraintSemantics = constraintSemantics;
        this.indexProviderMap = indexProviderMap;
    }

    @Override
    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaState.clear();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    @Override
    public void visitCreatedNode(long id) {
        this.recordState.nodeCreate(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.recordState.nodeDelete(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
        this.recordState.relCreate(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        this.recordState.relDelete(id);
    }

    @Override
    public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        StorageProperty prop;
        while (removed.hasNext()) {
            this.recordState.nodeRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        StorageProperty prop;
        while (removed.hasNext()) {
            this.recordState.relRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        StorageProperty prop;
        while (removed.hasNext()) {
            this.recordState.graphRemoveProperty(removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) {
        for (Integer label : removed) {
            this.recordState.removeLabelFromNode(label, id);
        }
        for (Integer label : added) {
            this.recordState.addLabelToNode(label, id);
        }
    }

    @Override
    public void visitAddedIndex(SchemaIndexDescriptor index, IndexProvider.Descriptor providerDescriptor) {
        if (providerDescriptor == null) {
            providerDescriptor = this.indexProviderMap.getDefaultProvider().getProviderDescriptor();
        } else if (this.indexProviderMap.lookup(providerDescriptor) == null) {
            throw new IllegalArgumentException("Specified non-existent provider '" + providerDescriptor + "' for created index " + index);
        }
        IndexRule rule = IndexRule.indexRule(this.schemaStorage.newRuleId(), index, providerDescriptor);
        this.recordState.createSchemaRule(rule);
    }

    @Override
    public void visitRemovedIndex(SchemaIndexDescriptor index) {
        IndexRule rule = this.schemaStorage.indexGetForSchema(index);
        if (rule != null) {
            this.recordState.dropSchemaRule(rule);
        }
    }

    @Override
    public void visitAddedConstraint(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId();
        switch (constraint.type()) {
            case UNIQUE: {
                this.visitAddedUniquenessConstraint((UniquenessConstraintDescriptor)constraint, constraintId);
                break;
            }
            case UNIQUE_EXISTS: {
                this.visitAddedNodeKeyConstraint((NodeKeyConstraintDescriptor)constraint, constraintId);
                break;
            }
            case EXISTS: {
                this.recordState.createSchemaRule(this.constraintSemantics.createExistenceConstraint(this.schemaStorage.newRuleId(), constraint));
                break;
            }
            default: {
                throw new IllegalStateException(constraint.type().toString());
            }
        }
    }

    private void visitAddedUniquenessConstraint(UniquenessConstraintDescriptor uniqueConstraint, long constraintId) {
        IndexRule indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createUniquenessConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    private void visitAddedNodeKeyConstraint(NodeKeyConstraintDescriptor uniqueConstraint, long constraintId) throws CreateConstraintFailureException {
        IndexRule indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createNodeKeyConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    @Override
    public void visitRemovedConstraint(ConstraintDescriptor constraint) {
        this.clearSchemaState = true;
        try {
            this.recordState.dropSchemaRule(this.schemaStorage.constraintsGetSingle(constraint));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException e) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.");
        }
        if (constraint.enforcesUniqueness()) {
            this.visitRemovedIndex(((IndexBackedConstraintDescriptor)constraint).ownedIndexDescriptor());
        }
    }

    @Override
    public void visitCreatedLabelToken(String name, int id) {
        this.recordState.createLabelToken(name, id);
    }

    @Override
    public void visitCreatedPropertyKeyToken(String name, int id) {
        this.recordState.createPropertyKeyToken(name, id);
    }

    @Override
    public void visitCreatedRelationshipTypeToken(String name, int id) {
        this.recordState.createRelationshipTypeToken(name, id);
    }
}

