/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.Metadata;
import org.neo4j.kernel.impl.store.kvstore.SearchKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class KeyValueStoreFile
implements Closeable {
    private final PagedFile file;
    private final int keySize;
    private final int valueSize;
    private final Headers headers;
    private final int headerEntries;
    private final int totalEntries;
    private final byte[] pageCatalogue;

    KeyValueStoreFile(PagedFile file, int keySize, int valueSize, Metadata metadata) {
        this.file = file;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.headerEntries = metadata.headerEntries();
        this.totalEntries = metadata.totalEntries();
        this.headers = metadata.headers();
        this.pageCatalogue = metadata.pageCatalogue();
    }

    public Headers headers() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(SearchKey search, KeyValueVisitor visitor) throws IOException {
        BigEndianByteArrayBuffer searchKey = BigEndianByteArrayBuffer.newBuffer(this.keySize);
        BigEndianByteArrayBuffer key = BigEndianByteArrayBuffer.newBuffer(this.keySize);
        BigEndianByteArrayBuffer value = BigEndianByteArrayBuffer.newBuffer(this.valueSize);
        search.searchKey(searchKey);
        int page = KeyValueStoreFile.findPage(searchKey, this.pageCatalogue);
        if (page < 0 || page >= this.pageCatalogue.length / (this.keySize * 2)) {
            return false;
        }
        Throwable throwable = null;
        try (PageCursor cursor = this.file.io((long)page, 1);){
            boolean bl;
            if (!cursor.next()) {
                boolean bl2 = false;
                return bl2;
            }
            int offset = this.findByteOffset(cursor, searchKey, key, value);
            try {
                bl = Arrays.equals(searchKey.buffer, key.buffer);
            }
            catch (Throwable throwable2) {
                try {
                    KeyValueStoreFile.visitKeyValuePairs(this.file.pageSize(), cursor, offset, visitor, false, key, value);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            KeyValueStoreFile.visitKeyValuePairs(this.file.pageSize(), cursor, offset, visitor, false, key, value);
            return bl;
        }
    }

    public DataProvider dataProvider() throws IOException {
        int pageId = this.headerEntries * (this.keySize + this.valueSize) / this.file.pageSize();
        final PageCursor cursor = this.file.io((long)pageId, 1);
        return new DataProvider(){
            int offset;
            boolean done;
            {
                this.offset = KeyValueStoreFile.this.headerEntries * (KeyValueStoreFile.this.keySize + KeyValueStoreFile.this.valueSize);
                this.done = !cursor.next();
            }

            @Override
            public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                if (this.done) {
                    return false;
                }
                KeyValueStoreFile.readKeyValuePair(cursor, this.offset, key, value);
                if (key.allZeroes()) {
                    this.done = true;
                    return false;
                }
                this.offset += key.size() + value.size();
                if (this.offset >= KeyValueStoreFile.this.file.pageSize()) {
                    this.offset = 0;
                    if (!cursor.next()) {
                        this.done = true;
                    }
                }
                return true;
            }

            @Override
            public void close() {
                cursor.close();
            }
        };
    }

    public void scan(KeyValueVisitor visitor) throws IOException {
        KeyValueStoreFile.scanAll(this.file, this.headerEntries * (this.keySize + this.valueSize), visitor, new BigEndianByteArrayBuffer(new byte[this.keySize]), new BigEndianByteArrayBuffer(new byte[this.valueSize]));
    }

    public int entryCount() {
        return this.totalEntries - this.headerEntries;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.file + "]";
    }

    static <Buffer extends BigEndianByteArrayBuffer> void scanAll(PagedFile file, int startOffset, EntryVisitor<? super Buffer> visitor, Buffer key, Buffer value) throws IOException {
        boolean visitHeaders = !(visitor instanceof KeyValueVisitor);
        try (PageCursor cursor = file.io((long)(startOffset / file.pageSize()), 1);){
            if (!cursor.next()) {
                return;
            }
            KeyValueStoreFile.readKeyValuePair(cursor, startOffset, key, value);
            KeyValueStoreFile.visitKeyValuePairs(file.pageSize(), cursor, startOffset, visitor, visitHeaders, key, value);
        }
    }

    private static <Buffer extends BigEndianByteArrayBuffer> void visitKeyValuePairs(int pageSize, PageCursor cursor, int offset, EntryVisitor<? super Buffer> visitor, boolean visitHeaders, Buffer key, Buffer value) throws IOException {
        while (KeyValueStoreFile.visitable(key, visitHeaders) && visitor.visit(key, value)) {
            if ((offset += key.size() + value.size()) >= pageSize) {
                offset = 0;
                if (!cursor.next()) {
                    return;
                }
            }
            KeyValueStoreFile.readKeyValuePair(cursor, offset, key, value);
        }
    }

    private static boolean visitable(BigEndianByteArrayBuffer key, boolean acceptZeroKey) {
        return acceptZeroKey || !key.allZeroes();
    }

    private static void readKeyValuePair(PageCursor cursor, int offset, WritableBuffer key, WritableBuffer value) throws IOException {
        do {
            cursor.setOffset(offset);
            key.getFrom(cursor);
            value.getFrom(cursor);
        } while (cursor.shouldRetry());
        if (cursor.checkAndClearBoundsFlag()) {
            KeyValueStoreFile.throwOutOfBounds(cursor, offset);
        }
    }

    private static void throwOutOfBounds(PageCursor cursor, int offset) {
        long pageId = cursor.getCurrentPageId();
        int pageSize = cursor.getCurrentPageSize();
        String file = cursor.getCurrentFile().getAbsolutePath();
        throw new UnderlyingStorageException("Out of page bounds when reading key-value pair from offset " + offset + " into page " + pageId + " (with a size of " + pageSize + " bytes) of file " + file);
    }

    static int findPage(BigEndianByteArrayBuffer key, byte[] catalogue) {
        int max = catalogue.length / (key.size() * 2) - 1;
        int min = 0;
        while (min <= max) {
            int mid = min + (max - min) / 2;
            int cmp = BigEndianByteArrayBuffer.compare(key.buffer, catalogue, mid * key.size() * 2);
            if (cmp == 0) {
                max = mid;
            }
            if (cmp > 0) {
                cmp = BigEndianByteArrayBuffer.compare(key.buffer, catalogue, mid * key.size() * 2 + key.size());
                if (cmp <= 0) {
                    return mid;
                }
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    private int findByteOffset(PageCursor cursor, BigEndianByteArrayBuffer searchKey, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) throws IOException {
        int entrySize = searchKey.size() + value.size();
        int last = KeyValueStoreFile.maxPage(this.file.pageSize(), entrySize, this.totalEntries);
        int firstEntry = cursor.getCurrentPageId() == 0L ? this.headerEntries : 0;
        int entryCount = this.totalEntries % (this.file.pageSize() / entrySize);
        if (cursor.getCurrentPageId() != (long)last || entryCount == 0) {
            entryCount = this.file.pageSize() / entrySize;
        }
        int entryOffset = KeyValueStoreFile.findEntryOffset(cursor, searchKey, key, value, firstEntry, entryCount - 1);
        return entryOffset * entrySize;
    }

    static int maxPage(int pageSize, int entrySize, int totalEntries) {
        int maxPage = totalEntries / (pageSize / entrySize);
        return maxPage * (pageSize / entrySize) == totalEntries ? maxPage - 1 : maxPage;
    }

    static int findEntryOffset(PageCursor cursor, BigEndianByteArrayBuffer searchKey, BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value, int min, int max) throws IOException {
        int entrySize = key.size() + value.size();
        while (min <= max) {
            int mid = min + (max - min) / 2;
            KeyValueStoreFile.readKeyValuePair(cursor, mid * entrySize, key, value);
            if (min == max) break;
            int cmp = BigEndianByteArrayBuffer.compare(searchKey.buffer, key.buffer, 0);
            if (cmp > 0) {
                min = mid + 1;
                continue;
            }
            max = mid;
        }
        return max;
    }
}

