/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

public class LogHeader {
    public static final int LOG_HEADER_SIZE = 16;
    public final byte logFormatVersion;
    public final long logVersion;
    public final long lastCommittedTxId;

    public LogHeader(byte logFormatVersion, long logVersion, long lastCommittedTxId) {
        this.logFormatVersion = logFormatVersion;
        this.logVersion = logVersion;
        this.lastCommittedTxId = lastCommittedTxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogHeader logHeader = (LogHeader)o;
        return this.lastCommittedTxId == logHeader.lastCommittedTxId && this.logFormatVersion == logHeader.logFormatVersion && this.logVersion == logHeader.logVersion;
    }

    public int hashCode() {
        int result = this.logFormatVersion;
        result = 31 * result + (int)(this.logVersion ^ this.logVersion >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxId ^ this.lastCommittedTxId >>> 32);
        return result;
    }

    public String toString() {
        return "LogHeader{logFormatVersion=" + this.logFormatVersion + ", logVersion=" + this.logVersion + ", lastCommittedTxId=" + this.lastCommittedTxId + '}';
    }
}

