/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.util.function.Predicate;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class DefaultFileDeletionEventListener
implements FileWatchEventListener {
    private final Log internalLog;
    private final Predicate<String> fileNameFilter;

    public DefaultFileDeletionEventListener(LogService logService, Predicate<String> fileNameFilter) {
        this.internalLog = logService.getInternalLog(this.getClass());
        this.fileNameFilter = fileNameFilter;
    }

    public void fileDeleted(String fileName) {
        if (!this.fileNameFilter.test(fileName)) {
            this.internalLog.error(String.format("'%s' which belongs to the store was deleted while database was running.", fileName));
        }
    }
}

