/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountGroupsStage;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeFirstGroupStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupCache;
import org.neo4j.unsafe.impl.batchimport.ScanAndCacheGroupsStage;
import org.neo4j.unsafe.impl.batchimport.WriteGroupsStage;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class RelationshipGroupDefragmenter {
    private final Configuration config;
    private final ExecutionMonitor executionMonitor;
    private final Monitor monitor;
    private final NumberArrayFactory numberArrayFactory;

    public RelationshipGroupDefragmenter(Configuration config, ExecutionMonitor executionMonitor, Monitor monitor, NumberArrayFactory numberArrayFactory) {
        this.config = config;
        this.executionMonitor = executionMonitor;
        this.monitor = monitor;
        this.numberArrayFactory = numberArrayFactory;
    }

    public void run(long memoryWeCanHoldForCertain, BatchingNeoStores neoStore, long highNodeId) {
        try (RelationshipGroupCache groupCache = new RelationshipGroupCache(this.numberArrayFactory, memoryWeCanHoldForCertain, highNodeId);){
            RecordStore<RelationshipGroupRecord> fromStore = neoStore.getTemporaryRelationshipGroupStore();
            RecordStore<RelationshipGroupRecord> toStore = neoStore.getRelationshipGroupStore();
            Configuration groupConfig = Configuration.withBatchSize(this.config, neoStore.getRelationshipGroupStore().getRecordsPerPage());
            MemoryUsageStatsProvider memoryUsage = new MemoryUsageStatsProvider(neoStore, groupCache);
            this.executeStage(new CountGroupsStage(groupConfig, fromStore, groupCache, memoryUsage));
            long fromNodeId = 0L;
            long toNodeId = 0L;
            while (fromNodeId < highNodeId) {
                toNodeId = groupCache.prepare(fromNodeId);
                this.monitor.defragmentingNodeRange(fromNodeId, toNodeId);
                this.executeStage(new ScanAndCacheGroupsStage(groupConfig, fromStore, groupCache, memoryUsage));
                this.executeStage(new WriteGroupsStage(groupConfig, groupCache, toStore));
                fromNodeId = toNodeId;
            }
            ByteArray groupCountCache = groupCache.getGroupCountCache();
            groupCountCache.clear();
            Configuration nodeConfig = Configuration.withBatchSize(this.config, neoStore.getNodeStore().getRecordsPerPage());
            this.executeStage(new NodeFirstGroupStage(nodeConfig, toStore, neoStore.getNodeStore(), groupCountCache));
        }
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Monitor(){};

        default public void defragmentingNodeRange(long fromNodeId, long toNodeId) {
        }
    }
}

