/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionValues;

public class LongCollisionValues
implements CollisionValues {
    private final LongArray cache;
    private long nextOffset;

    public LongCollisionValues(NumberArrayFactory factory, long length) {
        this.cache = factory.newLongArray(length, 0L);
    }

    @Override
    public long add(Object id) {
        long collisionIndex = this.nextOffset++;
        this.cache.set(collisionIndex, ((Number)id).longValue());
        return collisionIndex;
    }

    @Override
    public Object get(long offset) {
        return this.cache.get(offset);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

