/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.io.Serializable;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
    private final StorageReader storageReader;
    private final CountsRecordState counts;
    private final ReadableTransactionState txState;

    public TransactionCountingStateVisitor(TxStateVisitor next, StorageReader storageReader, ReadableTransactionState txState, CountsRecordState counts) {
        super(next);
        this.storageReader = storageReader;
        this.txState = txState;
        this.counts = counts;
    }

    @Override
    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1L, 1L);
        super.visitCreatedNode(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.counts.incrementNodeCount(-1L, -1L);
        this.storageReader.acquireSingleNodeCursor(id).forAll(this::decrementCountForLabelsAndRelationships);
        super.visitDeletedNode(id);
    }

    private void decrementCountForLabelsAndRelationships(NodeItem node) {
        MutableLongSet labelIds = node.labels();
        labelIds.forEach((LongProcedure & Serializable)labelId -> this.counts.incrementNodeCount(labelId, -1L));
        this.storageReader.degrees(node, (arg_0, arg_1, arg_2) -> this.lambda$decrementCountForLabelsAndRelationships$0((LongSet)labelIds, arg_0, arg_1, arg_2));
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
        this.updateRelationshipCount(startNode, type, endNode, 1);
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        try {
            this.storageReader.relationshipVisit(id, this.edge);
            this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
        }
        super.visitDeletedRelationship(id);
    }

    @Override
    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            added.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, 1L));
            removed.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, -1L));
            this.storageReader.acquireSingleNodeCursor(id).forAll(node -> this.storageReader.degrees((NodeItem)node, (type, out, in) -> {
                added.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, out, in));
                removed.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, -out, -in));
            }));
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(LongSet labels, int type, long outgoing, long incoming) {
        labels.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming));
    }

    private boolean updateRelationshipsCountsFromDegrees(int type, long label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, type, label, incoming);
        return false;
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1L, (long)delta, 0L);
        this.visitLabels(startNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, (long)delta, 0L));
        this.visitLabels(endNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, 0L, (long)delta));
    }

    private void visitLabels(long nodeId, LongConsumer visitor) {
        this.nodeCursor(nodeId).forAll(node -> node.labels().forEach(visitor::accept));
    }

    private Cursor<NodeItem> nodeCursor(long nodeId) {
        return this.txState.augmentSingleNodeCursor(this.storageReader.acquireSingleNodeCursor(nodeId), nodeId);
    }

    private /* synthetic */ void lambda$decrementCountForLabelsAndRelationships$0(LongSet labelIds, int type, long out, long in) {
        this.updateRelationshipsCountsFromDegrees(labelIds, type, -out, -in);
    }
}

