/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.txstate.NodeState;

public class TxSingleNodeCursor
implements Cursor<NodeItem>,
NodeItem {
    private final TransactionState state;
    private final Consumer<TxSingleNodeCursor> cache;
    private long id = -1L;
    private Cursor<NodeItem> cursor;
    private NodeState nodeState;
    private boolean nodeIsAddedInThisTx;

    public TxSingleNodeCursor(TransactionState state, Consumer<TxSingleNodeCursor> cache) {
        this.state = state;
        this.cache = cache;
    }

    public TxSingleNodeCursor init(Cursor<NodeItem> nodeCursor, long nodeId) {
        this.id = nodeId;
        this.cursor = nodeCursor;
        this.nodeIsAddedInThisTx = this.state.nodeIsAddedInThisTx(this.id);
        return this;
    }

    public NodeItem get() {
        if (this.id == -1L) {
            throw new IllegalStateException();
        }
        return this;
    }

    public boolean next() {
        if (this.id == -1L) {
            return false;
        }
        if (this.state.nodeIsDeletedInThisTx(this.id)) {
            this.id = -1L;
            return false;
        }
        if (this.cursor.next() || this.nodeIsAddedInThisTx) {
            this.nodeIsAddedInThisTx = false;
            this.nodeState = this.state.getNodeState(this.id);
            return true;
        }
        this.id = -1L;
        this.nodeState = null;
        return false;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.cache.accept(this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public MutableLongSet labels() {
        return this.state.augmentLabels((MutableLongSet)(this.nodeIsAddedInThisTx ? new LongHashSet() : ((NodeItem)this.cursor.get()).labels()), this.nodeState);
    }

    @Override
    public boolean hasLabel(long labelId) {
        if (this.nodeIsAddedInThisTx || this.nodeState.labelDiffSets().getRemoved().contains(labelId)) {
            return false;
        }
        if (this.nodeState.labelDiffSets().getAdded().contains(labelId)) {
            return true;
        }
        return ((NodeItem)this.cursor.get()).hasLabel(labelId);
    }

    @Override
    public boolean isDense() {
        return ((NodeItem)this.cursor.get()).isDense();
    }

    @Override
    public long nextGroupId() {
        return this.nodeIsAddedInThisTx ? Record.NO_NEXT_RELATIONSHIP.longValue() : ((NodeItem)this.cursor.get()).nextGroupId();
    }

    @Override
    public long nextRelationshipId() {
        return this.nodeIsAddedInThisTx ? Record.NO_NEXT_RELATIONSHIP.longValue() : ((NodeItem)this.cursor.get()).nextRelationshipId();
    }

    @Override
    public long nextPropertyId() {
        return this.nodeIsAddedInThisTx ? Record.NO_NEXT_PROPERTY.longValue() : ((NodeItem)this.cursor.get()).nextPropertyId();
    }

    @Override
    public Lock lock() {
        return this.nodeIsAddedInThisTx ? LockService.NO_LOCK : ((NodeItem)this.cursor.get()).lock();
    }
}

