/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final MutableLongObjectMap<IndexProxy> indexesById;
    private final Map<SchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByLabel;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty;

    public IndexMap() {
        this((MutableLongObjectMap<IndexProxy>)new LongObjectHashMap(), new HashMap<SchemaDescriptor, IndexProxy>(), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap());
    }

    IndexMap(MutableLongObjectMap<IndexProxy> indexesById) {
        this(indexesById, IndexMap.indexesByDescriptor(indexesById), IndexMap.indexIdsByDescriptor(indexesById));
    }

    private IndexMap(MutableLongObjectMap<IndexProxy> indexesById, Map<SchemaDescriptor, IndexProxy> indexesByDescriptor, MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.descriptorsByLabel = new IntObjectHashMap();
        this.descriptorsByProperty = new IntObjectHashMap();
        for (SchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get((Object)descriptor);
    }

    public void putIndexProxy(long indexId, IndexProxy indexProxy) {
        SchemaDescriptor schema = indexProxy.getDescriptor().schema();
        this.indexesById.put(indexId, (Object)indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put((Object)schema, indexId);
        this.addDescriptorToLookups(schema);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = (IndexProxy)this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        SchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        this.removeFromLookup(schema.keyId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.removeFromLookup(propertyId, schema, this.descriptorsByProperty);
        }
        return removedProxy;
    }

    void forEachIndexProxy(LongObjectProcedure<IndexProxy> consumer) {
        this.indexesById.forEachKeyValue(consumer);
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedLabels, long[] unchangedLabels, IntSet properties) {
        if (changedLabels.length == 1 && properties.isEmpty()) {
            Set descriptors = (Set)this.descriptorsByLabel.get((int)changedLabels[0]);
            return descriptors == null ? Collections.emptySet() : descriptors;
        }
        if (changedLabels.length == 0 && properties.size() == 1) {
            return this.getDescriptorsByProperties(unchangedLabels, properties);
        }
        Set<SchemaDescriptor> descriptors = this.extractIndexesByLabels(changedLabels);
        descriptors.addAll(this.getDescriptorsByProperties(unchangedLabels, properties));
        return descriptors;
    }

    public IndexMap clone() {
        return new IndexMap((MutableLongObjectMap<IndexProxy>)LongObjectHashMap.newMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap(this.indexIdsByDescriptor));
    }

    public Iterator<SchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public LongIterator indexIds() {
        return this.indexesById.keySet().longIterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    private void addDescriptorToLookups(SchemaDescriptor schema) {
        this.addToLookup(schema.keyId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.addToLookup(propertyId, schema, this.descriptorsByProperty);
        }
    }

    private void addToLookup(int key, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup) {
        HashSet<SchemaDescriptor> descriptors = (HashSet<SchemaDescriptor>)lookup.get(key);
        if (descriptors == null) {
            descriptors = new HashSet<SchemaDescriptor>();
            lookup.put(key, descriptors);
        }
        descriptors.add(schema);
    }

    private void removeFromLookup(int key, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup) {
        Set descriptors = (Set)lookup.get(key);
        descriptors.remove(schema);
        if (descriptors.isEmpty()) {
            lookup.remove(key);
        }
    }

    private static Map<SchemaDescriptor, IndexProxy> indexesByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        return indexesById.toMap(IndexProxy::schema, Functions.identity());
    }

    private static MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        ObjectLongHashMap map = new ObjectLongHashMap(indexesById.size());
        indexesById.forEachKeyValue((arg_0, arg_1) -> IndexMap.lambda$indexIdsByDescriptor$9c2f860d$1((MutableObjectLongMap)map, arg_0, arg_1));
        return map;
    }

    private Set<SchemaDescriptor> getDescriptorsByProperties(long[] unchangedLabels, IntSet properties) {
        int nIndexesForLabels = this.countIndexesByLabels(unchangedLabels);
        int nIndexesForProperties = this.countIndexesByProperties(properties);
        if (nIndexesForLabels == 0 || nIndexesForProperties == 0) {
            return Collections.emptySet();
        }
        if (nIndexesForLabels < nIndexesForProperties) {
            return this.extractIndexesByLabels(unchangedLabels);
        }
        return this.extractIndexesByProperties(properties);
    }

    private Set<SchemaDescriptor> extractIndexesByLabels(long[] labels) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            set.addAll(forLabel);
        }
        return set;
    }

    private int countIndexesByLabels(long[] labels) {
        int count = 0;
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            count += forLabel.size();
        }
        return count;
    }

    private Set<SchemaDescriptor> extractIndexesByProperties(IntSet properties) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        IntIterator iterator = properties.intIterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            set.addAll(forProperty);
        }
        return set;
    }

    private int countIndexesByProperties(IntSet properties) {
        int count = 0;
        IntIterator iterator = properties.intIterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            count += forProperty.size();
        }
        return count;
    }

    private static /* synthetic */ void lambda$indexIdsByDescriptor$9c2f860d$1(MutableObjectLongMap map, long id, IndexProxy indexProxy) {
        map.put((Object)indexProxy.schema(), id);
    }
}

