/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;

class PropertyContainerStateImpl
implements PropertyContainerState {
    private final long id;
    private MutableIntObjectMap<Value> addedProperties;
    private MutableIntObjectMap<Value> changedProperties;
    private MutableIntSet removedProperties;

    PropertyContainerStateImpl(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    void changeProperty(int propertyKeyId, Value value) {
        if (this.addedProperties != null && this.addedProperties.containsKey(propertyKeyId)) {
            this.addedProperties.put(propertyKeyId, (Object)value);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = new IntObjectHashMap();
        }
        this.changedProperties.put(propertyKeyId, (Object)value);
        if (this.removedProperties != null) {
            this.removedProperties.remove(propertyKeyId);
        }
    }

    void addProperty(int propertyKeyId, Value value) {
        if (this.removedProperties != null && this.removedProperties.remove(propertyKeyId)) {
            this.changeProperty(propertyKeyId, value);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = new IntObjectHashMap();
        }
        this.addedProperties.put(propertyKeyId, (Object)value);
    }

    void removeProperty(int propertyKeyId) {
        if (this.addedProperties != null && this.addedProperties.remove(propertyKeyId) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = new IntHashSet();
        }
        this.removedProperties.add(propertyKeyId);
        if (this.changedProperties != null) {
            this.changedProperties.remove(propertyKeyId);
        }
    }

    @Override
    public Iterator<StorageProperty> addedProperties() {
        return this.toPropertyIterator((IntObjectMap<Value>)this.addedProperties);
    }

    @Override
    public Iterator<StorageProperty> changedProperties() {
        return this.toPropertyIterator((IntObjectMap<Value>)this.changedProperties);
    }

    @Override
    public IntIterable removedProperties() {
        return this.removedProperties == null ? IntSets.immutable.empty() : this.removedProperties;
    }

    @Override
    public Iterator<StorageProperty> addedAndChangedProperties() {
        if (this.addedProperties == null) {
            return this.toPropertyIterator((IntObjectMap<Value>)this.changedProperties);
        }
        if (this.changedProperties == null) {
            return this.toPropertyIterator((IntObjectMap<Value>)this.addedProperties);
        }
        return Iterators.concat((Iterator[])new Iterator[]{this.toPropertyIterator((IntObjectMap<Value>)this.addedProperties), this.toPropertyIterator((IntObjectMap<Value>)this.changedProperties)});
    }

    @Override
    public boolean hasPropertyChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    @Override
    public StorageProperty getChangedProperty(int propertyKeyId) {
        return this.changedProperties == null ? null : this.getPropertyOrNull((IntObjectMap<Value>)this.changedProperties, propertyKeyId);
    }

    @Override
    public StorageProperty getAddedProperty(int propertyKeyId) {
        return this.addedProperties == null ? null : this.getPropertyOrNull((IntObjectMap<Value>)this.addedProperties, propertyKeyId);
    }

    @Override
    public boolean isPropertyChangedOrRemoved(int propertyKey) {
        return this.removedProperties != null && this.removedProperties.contains(propertyKey) || this.changedProperties != null && this.changedProperties.containsKey(propertyKey);
    }

    @Override
    public boolean isPropertyRemoved(int propertyKeyId) {
        return this.removedProperties != null && this.removedProperties.contains(propertyKeyId);
    }

    private Iterator<StorageProperty> toPropertyIterator(IntObjectMap<Value> propertyMap) {
        return propertyMap == null ? Collections.emptyIterator() : propertyMap.keyValuesView().collect((Function & Serializable)e -> new PropertyKeyValue(e.getOne(), (Value)e.getTwo())).iterator();
    }

    private PropertyKeyValue getPropertyOrNull(IntObjectMap<Value> propertyMap, int propertyKeyId) {
        Value value = (Value)propertyMap.get(propertyKeyId);
        return value == null ? null : new PropertyKeyValue(propertyKeyId, value);
    }
}

