/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class DeferredConflictCheckingIndexUpdater
implements IndexUpdater {
    private final IndexUpdater actual;
    private final Supplier<IndexReader> readerSupplier;
    private final SchemaIndexDescriptor schemaIndexDescriptor;
    private final Set<ValueTuple> touchedTuples = new HashSet<ValueTuple>();

    public DeferredConflictCheckingIndexUpdater(IndexUpdater actual, Supplier<IndexReader> readerSupplier, SchemaIndexDescriptor schemaIndexDescriptor) {
        this.actual = actual;
        this.readerSupplier = readerSupplier;
        this.schemaIndexDescriptor = schemaIndexDescriptor;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        this.actual.process(update);
        if (update.updateMode() != UpdateMode.REMOVED) {
            this.touchedTuples.add(ValueTuple.of((Value[])update.values()));
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        this.actual.close();
        try (IndexReader reader = this.readerSupplier.get();){
            for (ValueTuple tuple : this.touchedTuples) {
                PrimitiveLongResourceIterator results = reader.query(this.queryOf(tuple));
                Throwable throwable = null;
                try {
                    if (!results.hasNext()) continue;
                    long firstEntityId = results.next();
                    if (!results.hasNext()) continue;
                    long secondEntityId = results.next();
                    throw new IndexEntryConflictException(firstEntityId, secondEntityId, tuple);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
        }
        catch (IndexNotApplicableKernelException e) {
            throw new IllegalArgumentException("Unexpectedly the index reader couldn't handle this query", (Throwable)((Object)e));
        }
    }

    private IndexQuery[] queryOf(ValueTuple tuple) {
        IndexQuery[] predicates = new IndexQuery[tuple.size()];
        int[] propertyIds = this.schemaIndexDescriptor.schema().getPropertyIds();
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = IndexQuery.exact((int)propertyIds[i], (Object)tuple.valueAt(i));
        }
        return predicates;
    }
}

