/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexReader;

public abstract class NativeSchemaIndexAccessor<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeSchemaIndex<KEY, VALUE>
implements IndexAccessor {
    private final NativeSchemaIndexUpdater<KEY, VALUE> singleUpdater;
    final IndexSamplingConfig samplingConfig;

    NativeSchemaIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, indexId);
        this.singleUpdater = new NativeSchemaIndexUpdater<NativeSchemaKey, NativeSchemaValue>((NativeSchemaKey)((Object)layout.newKey()), (NativeSchemaValue)layout.newValue());
        this.samplingConfig = samplingConfig;
        this.instantiateTree(recoveryCleanupWorkCollector, GBPTree.NO_HEADER_WRITER);
    }

    @Override
    public void drop() throws IOException {
        this.closeTree();
        this.fileSystem.deleteFileOrThrow(this.storeFile);
    }

    @Override
    public NativeSchemaIndexUpdater<KEY, VALUE> newUpdater(IndexUpdateMode mode) {
        this.assertOpen();
        try {
            return this.singleUpdater.initialize(this.tree.writer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        this.tree.checkpoint(ioLimiter);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() throws IOException {
        this.closeTree();
    }

    @Override
    public boolean isDirty() {
        return this.tree.wasDirtyOnStartup();
    }

    @Override
    public abstract IndexReader newReader();

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        return new NativeAllEntriesReader(this.tree, this.layout);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) {
    }
}

