/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.schema.IndexSample;

class FusionIndexPopulator
extends FusionIndexBase<IndexPopulator>
implements IndexPopulator {
    private final long indexId;
    private final FusionIndexProvider.DropAction dropAction;
    private final boolean archiveFailedIndex;

    FusionIndexPopulator(SlotSelector slotSelector, InstanceSelector<IndexPopulator> instanceSelector, long indexId, FusionIndexProvider.DropAction dropAction, boolean archiveFailedIndex) {
        super(slotSelector, instanceSelector);
        this.indexId = indexId;
        this.dropAction = dropAction;
        this.archiveFailedIndex = archiveFailedIndex;
    }

    @Override
    public void create() throws IOException {
        this.dropAction.drop(this.indexId, this.archiveFailedIndex);
        this.instanceSelector.forAll(IndexPopulator::create);
    }

    @Override
    public void drop() {
        this.instanceSelector.forAll(IndexPopulator::drop);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        LazyInstanceSelector<Collection> batchSelector = new LazyInstanceSelector<Collection>(new Collection[5], slot -> new ArrayList());
        for (IndexEntryUpdate<?> update : updates) {
            batchSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF)).add(update);
        }
        for (int slot2 = 0; slot2 < 5; ++slot2) {
            Collection batch = batchSelector.getIfInstantiated(slot2);
            if (batch == null) continue;
            ((IndexPopulator)this.instanceSelector.select(slot2)).add(batch);
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        for (int slot = 0; slot < 5; ++slot) {
            ((IndexPopulator)this.instanceSelector.select(slot)).verifyDeferredConstraints(propertyAccessor);
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(new IndexUpdater[5], slot -> ((IndexPopulator)this.instanceSelector.select(slot)).newPopulatingUpdater(accessor));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        this.instanceSelector.close(populator -> populator.close(populationCompletedSuccessfully));
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.instanceSelector.forAll(populator -> populator.markAsFailed(failure));
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        ((IndexPopulator)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionIndexSampler.combineSamples(this.instanceSelector.instancesAs(new IndexSample[5], IndexPopulator::sampleResult));
    }
}

