/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Modes;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.impl.newapi.KernelSession;
import org.neo4j.storageengine.api.StorageEngine;

public class NewKernel
implements Kernel,
Modes {
    private final StorageEngine engine;
    private final InwardKernel kernel;
    private volatile boolean isRunning;

    public NewKernel(StorageEngine engine, InwardKernel kernel) {
        this.engine = engine;
        this.kernel = kernel;
        this.isRunning = false;
    }

    public KernelSession beginSession(LoginContext loginContext) {
        assert (this.isRunning) : "kernel is not running, so it is not possible to use it";
        return new KernelSession(this.kernel, loginContext);
    }

    public Modes modes() {
        return this;
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            throw new IllegalStateException("kernel is not running, so it is not possible to stop it");
        }
        this.isRunning = false;
    }

    public boolean twoLayerTransactionState() {
        return false;
    }
}

