/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.values.storable.ValueCategory;

public class UnionIndexCapability
implements IndexCapability {
    private final IndexCapability[] capabilities;

    public UnionIndexCapability(IndexCapability ... capabilities) {
        this.capabilities = capabilities;
    }

    public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
        HashSet<IndexOrder> orderCapability = new HashSet<IndexOrder>();
        for (IndexCapability capability : this.capabilities) {
            orderCapability.addAll(Arrays.asList(capability.orderCapability(valueCategories)));
        }
        return orderCapability.toArray(new IndexOrder[orderCapability.size()]);
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        IndexValueCapability currentBest = IndexValueCapability.NO;
        for (IndexCapability capability : this.capabilities) {
            IndexValueCapability next = capability.valueCapability(valueCategories);
            if (next.compare(currentBest) <= 0) continue;
            currentBest = next;
        }
        return currentBest;
    }
}

