/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;

class DegreeCounter {
    private DegreeCounter() {
    }

    static long countByFirstPrevPointer(long relationshipId, RecordCursor<RelationshipRecord> cursor, long nodeId, RelationshipRecord relationshipRecord) {
        if (relationshipId == Record.NO_NEXT_RELATIONSHIP.longValue()) {
            return 0L;
        }
        cursor.next(relationshipId, relationshipRecord, RecordLoad.FORCE);
        if (relationshipRecord.getFirstNode() == nodeId) {
            return relationshipRecord.getFirstPrevRel();
        }
        if (relationshipRecord.getSecondNode() == nodeId) {
            return relationshipRecord.getSecondPrevRel();
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of " + relationshipRecord);
    }

    static int countRelationshipsInGroup(long groupId, Direction direction, Integer type, long nodeId, RelationshipRecord relationshipRecord, RelationshipGroupRecord groupRecord, RecordCursors cursors) {
        int count = 0;
        while (groupId != Record.NO_NEXT_RELATIONSHIP.longValue()) {
            boolean groupRecordInUse = cursors.relationshipGroup().next(groupId, groupRecord, RecordLoad.FORCE);
            if (groupRecordInUse && (type == null || groupRecord.getType() == type.intValue())) {
                count = (int)((long)count + DegreeCounter.nodeDegreeByDirection(direction, nodeId, relationshipRecord, groupRecord, cursors));
                if (type != null) break;
            }
            groupId = groupRecord.getNext();
        }
        return count;
    }

    private static long nodeDegreeByDirection(Direction direction, long nodeId, RelationshipRecord relationshipRecord, RelationshipGroupRecord groupRecord, RecordCursors cursors) {
        long firstLoop = groupRecord.getFirstLoop();
        RecordCursor<RelationshipRecord> cursor = cursors.relationship();
        long loopCount = DegreeCounter.countByFirstPrevPointer(firstLoop, cursor, nodeId, relationshipRecord);
        switch (direction) {
            case OUTGOING: {
                long firstOut = groupRecord.getFirstOut();
                return DegreeCounter.countByFirstPrevPointer(firstOut, cursor, nodeId, relationshipRecord) + loopCount;
            }
            case INCOMING: {
                long firstIn = groupRecord.getFirstIn();
                return DegreeCounter.countByFirstPrevPointer(firstIn, cursor, nodeId, relationshipRecord) + loopCount;
            }
            case BOTH: {
                long firstOut = groupRecord.getFirstOut();
                long firstIn = groupRecord.getFirstIn();
                return DegreeCounter.countByFirstPrevPointer(firstOut, cursor, nodeId, relationshipRecord) + DegreeCounter.countByFirstPrevPointer(firstIn, cursor, nodeId, relationshipRecord) + loopCount;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }
}

