/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.RenewableBatchIdSequences;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.lock.ResourceLocker;

class RecordStorageCommandCreationContext
implements CommandCreationContext {
    private final NeoStores neoStores;
    private final Loaders loaders;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final RenewableBatchIdSequences idBatches;

    RecordStorageCommandCreationContext(NeoStores neoStores, int denseNodeThreshold, int idBatchSize) {
        this.neoStores = neoStores;
        this.idBatches = new RenewableBatchIdSequences(neoStores, idBatchSize);
        this.loaders = new Loaders(neoStores);
        RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter(this.idBatches.idGenerator(StoreType.RELATIONSHIP_GROUP));
        this.relationshipCreator = new RelationshipCreator(relationshipGroupGetter, denseNodeThreshold);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        this.propertyDeleter = new PropertyDeleter(propertyTraverser);
        this.relationshipDeleter = new RelationshipDeleter(relationshipGroupGetter, this.propertyDeleter);
        this.propertyCreator = new PropertyCreator(new StandardDynamicRecordAllocator(this.idBatches.idGenerator(StoreType.PROPERTY_STRING), neoStores.getPropertyStore().getStringStore().getRecordDataSize()), new StandardDynamicRecordAllocator(this.idBatches.idGenerator(StoreType.PROPERTY_ARRAY), neoStores.getPropertyStore().getArrayStore().getRecordDataSize()), this.idBatches.idGenerator(StoreType.PROPERTY), propertyTraverser, neoStores.getPropertyStore().allowStorePointsAndTemporal());
    }

    public long nextId(StoreType storeType) {
        return this.idBatches.nextId(storeType);
    }

    public void close() {
        this.idBatches.close();
    }

    TransactionRecordState createTransactionRecordState(IntegrityValidator integrityValidator, long lastTransactionIdWhenStarted, ResourceLocker locks) {
        RecordChangeSet recordChangeSet = new RecordChangeSet(this.loaders);
        return new TransactionRecordState(this.neoStores, integrityValidator, recordChangeSet, lastTransactionIdWhenStarted, locks, this.relationshipCreator, this.relationshipDeleter, this.propertyCreator, this.propertyDeleter);
    }
}

