/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.AllIdIterator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.AllNodeIterator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.AllRelationshipIterator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.DegreeCounter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StorePropertyCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

class RecordStorageReader
implements StorageReader {
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final IndexingService indexService;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final SchemaStorage schemaStorage;
    private final CountsTracker counts;
    private final PropertyLoader propertyLoader;
    private final SchemaCache schemaCache;
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipsCursor;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursorCache;
    private final InstanceCache<StorePropertyCursor> propertyCursorCache;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private final Supplier<LabelScanReader> labelScanReaderSupplier;
    private final RecordCursors recordCursors;
    private final RecordStorageCommandCreationContext commandCreationContext;
    private IndexReaderFactory indexReaderFactory;
    private LabelScanReader labelScanReader;
    private boolean acquired;
    private boolean closed;

    RecordStorageReader(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, NeoStores neoStores, IndexingService indexService, SchemaCache schemaCache, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier, final LockService lockService, RecordStorageCommandCreationContext commandCreationContext) {
        this.neoStores = neoStores;
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.counts = neoStores.getCounts();
        this.propertyLoader = new PropertyLoader(neoStores);
        this.schemaCache = schemaCache;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanReaderSupplier = labelScanReaderSupplier;
        this.commandCreationContext = commandCreationContext;
        this.recordCursors = new RecordCursors(neoStores);
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor((NodeRecord)RecordStorageReader.this.nodeStore.newRecord(), this, RecordStorageReader.this.recordCursors, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor((RelationshipRecord)RecordStorageReader.this.relationshipStore.newRecord(), this, RecordStorageReader.this.recordCursors, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor((RelationshipRecord)RecordStorageReader.this.relationshipStore.newRecord(), this, RecordStorageReader.this.recordCursors, lockService);
            }
        };
        this.nodeRelationshipsCursor = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor((RelationshipRecord)RecordStorageReader.this.relationshipStore.newRecord(), (RelationshipGroupRecord)RecordStorageReader.this.relationshipGroupStore.newRecord(), this, RecordStorageReader.this.recordCursors, lockService);
            }
        };
        this.singlePropertyCursorCache = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(RecordStorageReader.this.recordCursors, this);
            }
        };
        this.propertyCursorCache = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(RecordStorageReader.this.recordCursors, this);
            }
        };
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException((Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public String labelGetName(long labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(Math.toIntExact(labelId))).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException(labelId, (Exception)e);
        }
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetForLabel(int labelId) {
        return this.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public SchemaIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.indexDescriptor(descriptor);
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schemaCache.indexDescriptorsForLabel(labelId);
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetAll() {
        return RecordStorageReader.toIndexDescriptors(this.schemaCache.indexRules());
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetRelatedToProperty(int propertyId) {
        return this.schemaCache.indexesByProperty(propertyId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(SchemaIndexDescriptor index) {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            Long owningConstraint = rule.getOwningConstraint();
            return this.schemaCache.hasConstraintRule(owningConstraint) ? owningConstraint : null;
        }
        return null;
    }

    @Override
    public long indexGetCommittedId(SchemaIndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule == null) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, index.schema());
        }
        return rule.getId();
    }

    @Override
    public InternalIndexState indexGetState(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor.schema()).getState();
    }

    @Override
    public IndexProvider.Descriptor indexGetProviderDescriptor(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor.schema()).getProviderDescriptor();
    }

    @Override
    public CapableIndexReference indexReference(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        boolean unique = descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE;
        SchemaDescriptor schema = descriptor.schema();
        IndexProxy indexProxy = this.indexService.getIndexProxy(schema);
        return new DefaultCapableIndexReference(unique, indexProxy.getIndexCapability(), indexProxy.getProviderDescriptor(), schema.keyId(), schema.getPropertyIds());
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getIndexPopulationProgress();
    }

    @Override
    public long indexSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        Register.DoubleLongRegister result = this.indexService.indexUpdatesAndSize(descriptor);
        return result.readSecond();
    }

    @Override
    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public String indexGetFailure(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getPopulationFailure().asString();
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.constraintsForSchema(descriptor);
    }

    @Override
    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return this.schemaCache.hasConstraintRule(descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)e);
        }
    }

    @Override
    public IntIterator graphGetPropertyKeys() {
        return new PropertyKeyIdIterator((Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver())));
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StorageProperty> graphGetAllProperties() {
        return (Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver()));
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> relationshipTypeGetAllTokens() {
        return this.relationshipTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((RelationshipTypeToken)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record = (RelationshipRecord)this.relationshipStore.getRecord(relationshipId, this.relationshipStore.newRecord(), RecordLoad.CHECK);
        if (!record.inUse()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public LongIterator nodesGetAll() {
        return new AllNodeIterator(this.nodeStore);
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return new AllRelationshipIterator(this.relationshipStore);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(NodeItem nodeItem, Direction direction) {
        return this.nodeGetRelationships(nodeItem, direction, Predicates.ALWAYS_TRUE_INT);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(NodeItem node, Direction direction, IntPredicate relTypes) {
        return this.acquireNodeRelationshipCursor(node.isDense(), node.id(), node.nextRelationshipId(), direction, relTypes);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(NodeItem node, AssertOpen assertOpen) {
        Lock lock = node.lock();
        return this.acquirePropertyCursor(node.nextPropertyId(), lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperty(NodeItem node, int propertyKeyId, AssertOpen assertOpen) {
        Lock lock = node.lock();
        return this.acquireSinglePropertyCursor(node.nextPropertyId(), propertyKeyId, lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(RelationshipItem relationship, AssertOpen assertOpen) {
        Lock lock = relationship.lock();
        return this.acquirePropertyCursor(relationship.nextPropertyId(), lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperty(RelationshipItem relationship, int propertyKeyId, AssertOpen assertOpen) {
        Lock lock = relationship.lock();
        return this.acquireSinglePropertyCursor(relationship.nextPropertyId(), propertyKeyId, lock, assertOpen);
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long nodesGetCount() {
        return this.nodeStore.getNumberOfIdsInUse();
    }

    @Override
    public long relationshipsGetCount() {
        return this.relationshipStore.getNumberOfIdsInUse();
    }

    @Override
    public int labelCount() {
        return this.labelTokenHolder.size();
    }

    @Override
    public int propertyKeyCount() {
        return this.propertyKeyTokenHolder.size();
    }

    @Override
    public int relationshipTypeCount() {
        return this.relationshipTokenHolder.size();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexUpdatesAndSize(this.tryGetIndexId(descriptor), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexSample(this.tryGetIndexId(descriptor), target);
    }

    private long tryGetIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexId(descriptor);
    }

    @Override
    public boolean nodeExists(long id) {
        return this.nodeStore.isInUse(id);
    }

    @Override
    public boolean relationshipExists(long id) {
        return this.relationshipStore.isInUse(id);
    }

    @Override
    public IntSet relationshipTypes(NodeItem node) {
        IntHashSet set = new IntHashSet();
        if (node.isDense()) {
            RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)this.relationshipGroupStore.newRecord();
            RecordCursor<RelationshipGroupRecord> cursor = this.recordCursors().relationshipGroup();
            long id = node.nextGroupId();
            while (id != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                if (cursor.next(id, groupRecord, RecordLoad.FORCE)) {
                    set.add(groupRecord.getType());
                }
                id = groupRecord.getNext();
            }
        } else {
            this.nodeGetRelationships(node, Direction.BOTH).forAll(arg_0 -> RecordStorageReader.lambda$relationshipTypes$0((MutableIntSet)set, arg_0));
        }
        return set;
    }

    @Override
    public void degrees(NodeItem nodeItem, DegreeVisitor visitor) {
        if (nodeItem.isDense()) {
            this.visitDenseNode(nodeItem, visitor);
        } else {
            this.visitNode(nodeItem, visitor);
        }
    }

    private IndexRule indexRule(SchemaIndexDescriptor index) {
        for (IndexRule rule : this.schemaCache.indexRules()) {
            if (!rule.getIndexDescriptor().equals(index)) continue;
            return rule;
        }
        return this.schemaStorage.indexGetForSchema(index);
    }

    @Override
    public int degreeRelationshipsInGroup(long nodeId, long groupId, Direction direction, Integer relType) {
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        RelationshipGroupRecord relationshipGroupRecord = (RelationshipGroupRecord)this.relationshipGroupStore.newRecord();
        return DegreeCounter.countRelationshipsInGroup(groupId, direction, relType, nodeId, relationshipRecord, relationshipGroupRecord, this.recordCursors());
    }

    @Override
    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        return this.schemaCache.getOrCreateDependantState(type, factory, this);
    }

    @Override
    public StorageReader.Nodes nodes() {
        return this.nodeStore;
    }

    @Override
    public StorageReader.Relationships relationships() {
        return this.relationshipStore;
    }

    @Override
    public StorageReader.Groups groups() {
        return this.relationshipGroupStore;
    }

    @Override
    public StorageReader.Properties properties() {
        return this.propertyStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visitNode(NodeItem nodeItem, DegreeVisitor visitor) {
        try (Cursor<RelationshipItem> relationships = this.nodeGetRelationships(nodeItem, Direction.BOTH);){
            block14: while (relationships.next()) {
                RelationshipItem rel = (RelationshipItem)relationships.get();
                int type = rel.type();
                switch (this.directionOf(nodeItem.id(), rel.id(), rel.startNode(), rel.endNode())) {
                    case OUTGOING: {
                        visitor.visitDegree(type, 1L, 0L);
                        continue block14;
                    }
                    case INCOMING: {
                        visitor.visitDegree(type, 0L, 1L);
                        continue block14;
                    }
                    case BOTH: {
                        visitor.visitDegree(type, 1L, 1L);
                        continue block14;
                    }
                }
            }
            return;
            throw new IllegalStateException("You found the missing direction!");
        }
    }

    private void visitDenseNode(NodeItem nodeItem, DegreeVisitor visitor) {
        RelationshipGroupRecord relationshipGroupRecord = (RelationshipGroupRecord)this.relationshipGroupStore.newRecord();
        RecordCursor<RelationshipGroupRecord> relationshipGroupCursor = this.recordCursors().relationshipGroup();
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        RecordCursor<RelationshipRecord> relationshipCursor = this.recordCursors().relationship();
        long groupId = nodeItem.nextGroupId();
        while (groupId != Record.NO_NEXT_RELATIONSHIP.longValue()) {
            relationshipGroupCursor.next(groupId, relationshipGroupRecord, RecordLoad.FORCE);
            if (relationshipGroupRecord.inUse()) {
                int type = relationshipGroupRecord.getType();
                long firstLoop = relationshipGroupRecord.getFirstLoop();
                long firstOut = relationshipGroupRecord.getFirstOut();
                long firstIn = relationshipGroupRecord.getFirstIn();
                long loop = DegreeCounter.countByFirstPrevPointer(firstLoop, relationshipCursor, nodeItem.id(), relationshipRecord);
                long outgoing = DegreeCounter.countByFirstPrevPointer(firstOut, relationshipCursor, nodeItem.id(), relationshipRecord) + loop;
                long incoming = DegreeCounter.countByFirstPrevPointer(firstIn, relationshipCursor, nodeItem.id(), relationshipRecord) + loop;
                visitor.visitDegree(type, outgoing, incoming);
            }
            groupId = relationshipGroupRecord.getNext();
        }
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }

    private static Iterator<SchemaIndexDescriptor> toIndexDescriptors(Iterable<IndexRule> rules) {
        return Iterators.map(IndexRule::getIndexDescriptor, rules.iterator());
    }

    @Override
    public void acquire() {
        assert (!this.closed);
        assert (!this.acquired);
        this.acquired = true;
    }

    @Override
    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    @Override
    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    @Override
    public Cursor<RelationshipItem> acquireNodeRelationshipCursor(boolean isDense, long nodeId, long relationshipId, Direction direction, IntPredicate relTypeFilter) {
        this.neoStores.assertOpen();
        return this.nodeRelationshipsCursor.get().init(isDense, relationshipId, nodeId, direction, relTypeFilter);
    }

    @Override
    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init((LongIterator)new AllIdIterator(this.relationshipStore));
    }

    @Override
    public Cursor<PropertyItem> acquirePropertyCursor(long propertyId, Lock lock, AssertOpen assertOpen) {
        return this.propertyCursorCache.get().init(propertyId, lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> acquireSinglePropertyCursor(long propertyId, int propertyKeyId, Lock lock, AssertOpen assertOpen) {
        return this.singlePropertyCursorCache.get().init(propertyId, propertyKeyId, lock, assertOpen);
    }

    @Override
    public void release() {
        assert (!this.closed);
        assert (this.acquired);
        this.closeSchemaResources();
        this.acquired = false;
    }

    @Override
    public void close() {
        assert (!this.closed);
        this.closeSchemaResources();
        this.recordCursors.close();
        this.commandCreationContext.close();
        this.closed = true;
    }

    private void closeSchemaResources() {
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
    }

    @Override
    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanReaderSupplier.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    @Override
    public IndexReader getIndexReader(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(descriptor);
    }

    @Override
    public IndexReader getFreshIndexReader(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(descriptor);
    }

    @Override
    public RecordCursors recordCursors() {
        return this.recordCursors;
    }

    public RecordStorageCommandCreationContext getCommandCreationContext() {
        return this.commandCreationContext;
    }

    @Override
    public long reserveNode() {
        return this.commandCreationContext.nextId(StoreType.NODE);
    }

    @Override
    public long reserveRelationship() {
        return this.commandCreationContext.nextId(StoreType.RELATIONSHIP);
    }

    @Override
    public long getGraphPropertyReference() {
        return this.neoStores.getMetaDataStore().getGraphNextProp();
    }

    private static /* synthetic */ void lambda$relationshipTypes$0(MutableIntSet set, RelationshipItem relationship) {
        set.add(relationship.type());
    }
}

