/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.RelationshipItem;

abstract class StoreAbstractRelationshipCursor
implements Cursor<RelationshipItem>,
RelationshipItem {
    protected final RelationshipRecord relationshipRecord;
    final RecordCursor<RelationshipRecord> relationshipRecordCursor;
    private final LockService lockService;

    StoreAbstractRelationshipCursor(RelationshipRecord relationshipRecord, RecordCursors cursors, LockService lockService) {
        this.relationshipRecordCursor = cursors.relationship();
        this.relationshipRecord = relationshipRecord;
        this.lockService = lockService;
    }

    public RelationshipItem get() {
        return this;
    }

    @Override
    public long id() {
        return this.relationshipRecord.getId();
    }

    @Override
    public int type() {
        return this.relationshipRecord.getType();
    }

    @Override
    public long startNode() {
        return this.relationshipRecord.getFirstNode();
    }

    @Override
    public long endNode() {
        return this.relationshipRecord.getSecondNode();
    }

    @Override
    public long otherNode(long nodeId) {
        return this.relationshipRecord.getFirstNode() == nodeId ? this.relationshipRecord.getSecondNode() : this.relationshipRecord.getFirstNode();
    }

    @Override
    public long nextPropertyId() {
        return this.relationshipRecord.getNextProp();
    }

    @Override
    public Lock lock() {
        Lock lock = this.lockService.acquireRelationshipLock(this.relationshipRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = false;
            try {
                if (!this.relationshipRecordCursor.next(this.relationshipRecord.getId(), this.relationshipRecord, RecordLoad.FORCE)) {
                    this.relationshipRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }
}

