/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.storageengine.api.StorageProperty;

public interface PropertyContainerState {
    public static final PropertyContainerState EMPTY = new EmptyPropertyContainerState();

    public Iterator<StorageProperty> addedProperties();

    public Iterator<StorageProperty> changedProperties();

    public IntIterable removedProperties();

    public Iterator<StorageProperty> addedAndChangedProperties();

    public boolean hasPropertyChanges();

    public StorageProperty getChangedProperty(int var1);

    public StorageProperty getAddedProperty(int var1);

    public boolean isPropertyChangedOrRemoved(int var1);

    public boolean isPropertyRemoved(int var1);

    public static class EmptyPropertyContainerState
    implements PropertyContainerState {
        @Override
        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasPropertyChanges() {
            return false;
        }

        @Override
        public StorageProperty getChangedProperty(int propertyKeyId) {
            return null;
        }

        @Override
        public StorageProperty getAddedProperty(int propertyKeyId) {
            return null;
        }

        @Override
        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        @Override
        public boolean isPropertyRemoved(int propertyKeyId) {
            return false;
        }
    }
}

