/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.storageengine.api.Token;

class BatchTokenHolder {
    private final Map<String, Token> nameToToken = new HashMap<String, Token>();
    private final MutableIntObjectMap<Token> idToToken = new IntObjectHashMap(20);

    BatchTokenHolder(List<? extends Token> tokens) {
        for (Token token : tokens) {
            this.addToken(token);
        }
    }

    void addToken(Token token) {
        this.nameToToken.put(token.name(), token);
        this.idToToken.put(token.id(), (Object)token);
    }

    Token byId(int id) {
        return (Token)this.idToToken.get(id);
    }

    Token byName(String name) {
        return this.nameToToken.get(name);
    }
}

