/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionRepresentationCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;

    public TransactionRepresentationCommitProcess(TransactionAppender appender, StorageEngine storageEngine) {
        this.appender = appender;
        this.storageEngine = storageEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        long lastTxId = this.appendToLog(batch, commitEvent);
        try {
            this.applyToStore(batch, commitEvent, mode);
            long l = lastTxId;
            return l;
        }
        finally {
            this.close(batch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long appendToLog(TransactionToApply batch, CommitEvent commitEvent) throws TransactionFailureException {
        try (LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();){
            long l = this.appender.append(batch, logAppendEvent);
            return l;
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionLogError, cause, "Could not append transaction representation to log", new Object[0]);
        }
    }

    private void applyToStore(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
            this.storageEngine.apply((CommandsToApply)batch, mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not apply the transaction to the store after written to log", new Object[0]);
        }
    }

    private void close(TransactionToApply batch) {
        while (batch != null) {
            if (batch.commitment().markedAsCommitted()) {
                batch.commitment().publishAsClosed();
            }
            batch.close();
            batch = batch.next();
        }
    }
}

