/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.GraphStateImpl;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.DiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.GraphState;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private final CollectionsFactory collectionsFactory;
    private MutableLongObjectMap<MutableLongDiffSets> labelStatesMap;
    private MutableLongObjectMap<NodeStateImpl> nodeStatesMap;
    private MutableLongObjectMap<RelationshipStateImpl> relationshipStatesMap;
    private MutableLongObjectMap<String> createdLabelTokens;
    private MutableLongObjectMap<String> createdPropertyKeyTokens;
    private MutableLongObjectMap<String> createdRelationshipTypeTokens;
    private GraphStateImpl graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<ConstraintDescriptor> constraintsChanges;
    private RemovalsCountingDiffSets nodes;
    private RemovalsCountingDiffSets relationships;
    private MutableObjectLongMap<IndexBackedConstraintDescriptor> createdConstraintIndexesByConstraint;
    private Map<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>> indexUpdates;
    private boolean hasChanges;
    private boolean hasDataChanges;

    public TxState() {
        this(OnHeapCollectionsFactory.INSTANCE);
    }

    public TxState(CollectionsFactory collectionsFactory) {
        this.collectionsFactory = collectionsFactory;
    }

    public void accept(TxStateVisitor visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        if (this.nodes != null) {
            this.nodes.getAdded().each(arg_0 -> ((TxStateVisitor)visitor).visitCreatedNode(arg_0));
        }
        if (this.relationships != null) {
            LongIterator added = this.relationships.getAdded().longIterator();
            while (added.hasNext()) {
                long relId = added.next();
                if (this.relationshipVisit(relId, (arg_0, arg_1, arg_2, arg_3) -> ((TxStateVisitor)visitor).visitCreatedRelationship(arg_0, arg_1, arg_2, arg_3))) continue;
                throw new IllegalStateException("No RelationshipState for added relationship!");
            }
            this.relationships.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitDeletedRelationship(arg_0));
        }
        if (this.nodes != null) {
            this.nodes.getRemoved().each(arg_0 -> ((TxStateVisitor)visitor).visitDeletedNode(arg_0));
        }
        for (NodeState node : this.modifiedNodes()) {
            LongDiffSets labelDiffSets;
            if (node.hasPropertyChanges()) {
                visitor.visitNodePropertyChanges(node.getId(), node.addedProperties(), node.changedProperties(), node.removedProperties());
            }
            if ((labelDiffSets = node.labelDiffSets()).isEmpty()) continue;
            visitor.visitNodeLabelChanges(node.getId(), labelDiffSets.getAdded(), labelDiffSets.getRemoved());
        }
        for (RelationshipState rel : this.modifiedRelationships()) {
            visitor.visitRelPropertyChanges(rel.getId(), rel.addedProperties(), rel.changedProperties(), rel.removedProperties());
        }
        if (this.graphState != null) {
            visitor.visitGraphPropertyChanges(this.graphState.addedProperties(), this.graphState.changedProperties(), this.graphState.removedProperties());
        }
        if (this.indexChanges != null) {
            this.indexChanges.getAdded().forEach(arg_0 -> ((TxStateVisitor)visitor).visitAddedIndex(arg_0));
            this.indexChanges.getRemoved().forEach(arg_0 -> ((TxStateVisitor)visitor).visitRemovedIndex(arg_0));
        }
        if (this.constraintsChanges != null) {
            this.constraintsChanges.accept(new ConstraintDiffSetsVisitor(visitor));
        }
        if (this.createdLabelTokens != null) {
            this.createdLabelTokens.forEachKeyValue((arg_0, arg_1) -> ((TxStateVisitor)visitor).visitCreatedLabelToken(arg_0, arg_1));
        }
        if (this.createdPropertyKeyTokens != null) {
            this.createdPropertyKeyTokens.forEachKeyValue((arg_0, arg_1) -> ((TxStateVisitor)visitor).visitCreatedPropertyKeyToken(arg_0, arg_1));
        }
        if (this.createdRelationshipTypeTokens != null) {
            this.createdRelationshipTypeTokens.forEachKeyValue((arg_0, arg_1) -> ((TxStateVisitor)visitor).visitCreatedRelationshipTypeToken(arg_0, arg_1));
        }
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public Iterable<NodeState> modifiedNodes() {
        return this.nodeStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.nodeStatesMap.values());
    }

    private MutableLongDiffSets getOrCreateLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            this.labelStatesMap = new LongObjectHashMap();
        }
        return (MutableLongDiffSets)this.labelStatesMap.getIfAbsentPut(labelId, (Function0 & Serializable)() -> new MutableLongDiffSetsImpl(this.collectionsFactory));
    }

    private LongDiffSets getLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            return LongDiffSets.EMPTY;
        }
        LongDiffSets nodeDiffSets = (LongDiffSets)this.labelStatesMap.get(labelId);
        return nodeDiffSets == null ? LongDiffSets.EMPTY : nodeDiffSets;
    }

    public LongDiffSets nodeStateLabelDiffSets(long nodeId) {
        return this.getNodeState(nodeId).labelDiffSets();
    }

    private MutableLongDiffSets getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded(nodeId);
    }

    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded(relationshipId);
    }

    private void changed() {
        this.hasChanges = true;
    }

    private void dataChanged() {
        this.changed();
        this.hasDataChanges = true;
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add(id);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        this.nodes().remove(nodeId);
        if (this.nodeStatesMap != null && (nodeState = (NodeStateImpl)this.nodeStatesMap.remove(nodeId)) != null) {
            LongDiffSets diff = nodeState.labelDiffSets();
            diff.getAdded().each((LongProcedure & Serializable)label -> this.getOrCreateLabelStateNodeDiffSets(label).remove(nodeId));
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, RelationshipDirection.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.wasRemoved(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        this.relationships().remove(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, RelationshipDirection.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = (RelationshipStateImpl)this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        this.getRelationshipState(relationshipId).accept(this::relationshipDoDelete);
    }

    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.wasRemoved(relationshipId);
    }

    @Override
    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value);
        this.dataChanged();
    }

    @Override
    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void graphDoReplaceProperty(int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateGraphState().changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateGraphState().addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, int propertyKeyId) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void graphDoRemoveProperty(int propertyKeyId) {
        this.getOrCreateGraphState().removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add(labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, long id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new LongObjectHashMap();
        }
        this.createdLabelTokens.put(id, (Object)labelName);
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new LongObjectHashMap();
        }
        this.createdPropertyKeyTokens.put((long)id, (Object)propertyKeyName);
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new LongObjectHashMap();
        }
        this.createdRelationshipTypeTokens.put((long)id, (Object)labelName);
        this.changed();
    }

    public NodeState getNodeState(long id) {
        if (this.nodeStatesMap == null) {
            return NodeStateImpl.EMPTY;
        }
        NodeState nodeState = (NodeState)this.nodeStatesMap.get(id);
        return nodeState == null ? NodeStateImpl.EMPTY : nodeState;
    }

    public RelationshipState getRelationshipState(long id) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id);
        return relationshipState == null ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    public GraphState getGraphState() {
        return this.graphState;
    }

    public MutableLongSet augmentLabels(MutableLongSet labels, NodeState nodeState) {
        LongDiffSets labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(arg_0 -> ((MutableLongSet)labels).remove(arg_0));
            labelDiffSets.getAdded().forEach(arg_0 -> ((MutableLongSet)labels).add(arg_0));
        }
        return labels;
    }

    public LongDiffSets nodesWithLabelChanged(long label) {
        return this.getLabelStateNodeDiffSets(label);
    }

    @Override
    public void indexDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (!diff.unRemove((Object)descriptor)) {
            diff.add((Object)descriptor);
        }
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove((Object)descriptor);
        this.changed();
    }

    @Override
    public boolean indexDoUnRemove(IndexDescriptor descriptor) {
        return this.indexChangesDiffSets().unRemove((Object)descriptor);
    }

    public ReadableDiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public ReadableDiffSets<IndexDescriptor> indexDiffSetsBySchema(SchemaDescriptor schema) {
        return this.indexChangesDiffSets().filterAdded(indexDescriptor -> indexDescriptor.schema().equals(schema));
    }

    public ReadableDiffSets<IndexDescriptor> indexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.indexChanges);
    }

    private DiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    public LongDiffSets addedAndRemovedNodes() {
        return this.nodes == null ? LongDiffSets.EMPTY : this.nodes;
    }

    private RemovalsCountingDiffSets nodes() {
        if (this.nodes == null) {
            this.nodes = new RemovalsCountingDiffSets();
        }
        return this.nodes;
    }

    public LongDiffSets addedAndRemovedRelationships() {
        return this.relationships == null ? LongDiffSets.EMPTY : this.relationships;
    }

    private RemovalsCountingDiffSets relationships() {
        if (this.relationships == null) {
            this.relationships = new RemovalsCountingDiffSets();
        }
        return this.relationships;
    }

    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.relationshipStatesMap.values());
    }

    private NodeStateImpl getOrCreateNodeState(long nodeId) {
        if (this.nodeStatesMap == null) {
            this.nodeStatesMap = new LongObjectHashMap();
        }
        return (NodeStateImpl)this.nodeStatesMap.getIfAbsentPut(nodeId, (Function0 & Serializable)() -> new NodeStateImpl(nodeId, this.collectionsFactory));
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        if (this.relationshipStatesMap == null) {
            this.relationshipStatesMap = new LongObjectHashMap();
        }
        return (RelationshipStateImpl)this.relationshipStatesMap.getIfAbsentPut(relationshipId, (Function0 & Serializable)() -> new RelationshipStateImpl(relationshipId, this.collectionsFactory));
    }

    private GraphStateImpl getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphStateImpl(this.collectionsFactory);
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, long indexId) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.createdConstraintIndexesByConstraint().put((Object)constraint, indexId);
        this.changed();
    }

    @Override
    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.changed();
    }

    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptor.equalTo((SchemaDescriptor)descriptor));
    }

    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relTypeId));
    }

    public ReadableDiffSets<ConstraintDescriptor> constraintsChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private DiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        if (constraint.enforcesUniqueness()) {
            this.indexDoDrop(this.getIndexForIndexBackedConstraint((IndexBackedConstraintDescriptor)constraint));
        }
        this.changed();
    }

    @Override
    public boolean constraintDoUnRemove(ConstraintDescriptor constraint) {
        return this.constraintsChangesDiffSets().unRemove((Object)constraint);
    }

    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(this::getIndexForIndexBackedConstraint, (Iterable)this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    public Long indexCreatedForConstraint(ConstraintDescriptor constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : Long.valueOf(this.createdConstraintIndexesByConstraint.get((Object)constraint));
    }

    @Nullable
    public UnmodifiableMap<ValueTuple, ? extends LongDiffSets> getIndexUpdates(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(schema);
        if (updates == null) {
            return null;
        }
        return new UnmodifiableMap(updates);
    }

    @Nullable
    public NavigableMap<ValueTuple, ? extends LongDiffSets> getSortedIndexUpdates(SchemaDescriptor descriptor) {
        TreeMap<ValueTuple, MutableLongDiffSets> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<ValueTuple, MutableLongDiffSets>)updates;
        } else {
            sortedUpdates = new TreeMap<ValueTuple, MutableLongDiffSets>(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor, sortedUpdates);
        }
        return Collections.unmodifiableNavigableMap(sortedUpdates);
    }

    @Override
    public void indexDoUpdateEntry(SchemaDescriptor descriptor, long nodeId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        Map<ValueTuple, MutableLongDiffSets> updates = this.getOrCreateIndexUpdatesByDescriptor(descriptor);
        if (propertiesBefore != null) {
            MutableLongDiffSets before = this.getOrCreateIndexUpdatesForSeek(updates, propertiesBefore);
            before.remove(nodeId);
            if (before.getRemoved().contains(nodeId)) {
                nodeState.addIndexDiff(before);
            } else {
                nodeState.removeIndexDiff(before);
            }
        }
        if (propertiesAfter != null) {
            MutableLongDiffSets after = this.getOrCreateIndexUpdatesForSeek(updates, propertiesAfter);
            after.add(nodeId);
            if (after.getAdded().contains(nodeId)) {
                nodeState.addIndexDiff(after);
            } else {
                nodeState.removeIndexDiff(after);
            }
        }
    }

    private MutableLongDiffSets getOrCreateIndexUpdatesForSeek(Map<ValueTuple, MutableLongDiffSets> updates, ValueTuple values) {
        return updates.computeIfAbsent(values, value -> new MutableLongDiffSetsImpl());
    }

    private Map<ValueTuple, MutableLongDiffSets> getOrCreateIndexUpdatesByDescriptor(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            this.indexUpdates = new HashMap<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>>();
        }
        return this.indexUpdates.computeIfAbsent(schema, k -> new HashMap());
    }

    private MutableObjectLongMap<IndexBackedConstraintDescriptor> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new ObjectLongHashMap();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private IndexDescriptor getIndexForIndexBackedConstraint(IndexBackedConstraintDescriptor constraint) {
        return constraint.ownedIndexDescriptor();
    }

    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    public boolean hasDataChanges() {
        return this.hasDataChanges;
    }

    private class RemovalsCountingDiffSets
    extends MutableLongDiffSetsImpl {
        private MutableLongSet removedFromAdded;

        RemovalsCountingDiffSets() {
            super(TxState.this.collectionsFactory);
        }

        @Override
        public boolean remove(long elem) {
            if (this.isAdded(elem) && super.remove(elem)) {
                if (this.removedFromAdded == null) {
                    this.removedFromAdded = TxState.this.collectionsFactory.newLongSet();
                }
                this.removedFromAdded.add(elem);
                return true;
            }
            return super.remove(elem);
        }

        private boolean wasRemoved(long id) {
            return this.removedFromAdded != null && this.removedFromAdded.contains(id) || super.isRemoved(id);
        }
    }

    private static class ConstraintDiffSetsVisitor
    implements DiffSetsVisitor<ConstraintDescriptor> {
        private final TxStateVisitor visitor;

        ConstraintDiffSetsVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        public void visitAdded(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
            this.visitor.visitAddedConstraint(constraint);
        }

        public void visitRemoved(ConstraintDescriptor constraint) {
            this.visitor.visitRemovedConstraint(constraint);
        }
    }
}

