/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

class GenericIndexKeyValidator
implements Validator<Value[]> {
    private final int maxLength;
    private final Layout<CompositeGenericKey, NativeIndexValue> layout;

    GenericIndexKeyValidator(int maxLength, Layout<CompositeGenericKey, NativeIndexValue> layout) {
        this.maxLength = maxLength;
        this.layout = layout;
    }

    @Override
    public void validate(Value[] values) {
        int size;
        int worstCaseSize = GenericIndexKeyValidator.worstCaseLength(values);
        if (worstCaseSize > this.maxLength && (size = this.actualLength(values)) > this.maxLength) {
            throw new IllegalArgumentException(String.format("Property value size:%d of %s is too large to index into this particular index. Please see index documentation for limitations.", size, Arrays.toString(values)));
        }
    }

    private static int worstCaseLength(Value[] values) {
        int length = 8;
        for (Value value : values) {
            length += 8;
            length += GenericIndexKeyValidator.worstCaseLength((AnyValue)value);
        }
        return length;
    }

    private static int worstCaseLength(AnyValue value) {
        if (value.isSequenceValue()) {
            SequenceValue sequenceValue = (SequenceValue)value;
            int length = 0;
            for (int i = 0; i < sequenceValue.length(); ++i) {
                length += GenericIndexKeyValidator.worstCaseLength(sequenceValue.value(i));
            }
            return length;
        }
        switch (((Value)value).valueGroup().category()) {
            case TEXT: {
                return ((TextValue)value).length() * 4;
            }
        }
        return 32;
    }

    private int actualLength(Value[] values) {
        CompositeGenericKey key = (CompositeGenericKey)((Object)this.layout.newKey());
        key.initialize(0L);
        for (int i = 0; i < values.length; ++i) {
            key.initFromValue(i, values[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }
}

