/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.store.TemporalValueWriterAdapter;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class GenericKeyState
extends TemporalValueWriterAdapter<RuntimeException> {
    static final int BIGGEST_STATIC_SIZE = 32;
    private static final int SIZE_ZONED_DATE_TIME = 16;
    private static final int SIZE_LOCAL_DATE_TIME = 12;
    private static final int SIZE_DATE = 8;
    private static final int SIZE_ZONED_TIME = 12;
    private static final int SIZE_LOCAL_TIME = 8;
    private static final int SIZE_DURATION = 28;
    private static final int SIZE_BOOLEAN = 1;
    private static final int SIZE_NUMBER_TYPE = 1;
    private static final int SIZE_NUMBER = 8;
    private static final int SIZE_ARRAY_LENGTH = 4;
    private static final int BIGGEST_REASONABLE_ARRAY_LENGTH = 128;
    private static final long TRUE = 1L;
    private static final long FALSE = 0L;
    private static final int TYPE_ID_SIZE = 1;
    GenericLayout.Type type;
    NativeIndexKey.Inclusion inclusion;
    private boolean isArray;
    private int arrayLength;
    private int currentArrayOffset;
    private long long0;
    private long long1;
    private long long2;
    private long long3;
    private byte[] byteArray;
    private long[] long0Array;
    private long[] long1Array;
    private long[] long2Array;
    private long[] long3Array;
    private byte[][] byteArrayArray;

    GenericKeyState() {
    }

    void clear() {
        this.type = null;
        this.long0 = 0L;
        this.long1 = 0L;
        this.long2 = 0L;
        this.long3 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        this.isArray = false;
        this.arrayLength = 0;
        this.currentArrayOffset = 0;
    }

    void initializeToDummyValue() {
        this.clear();
        this.writeInteger(0);
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
    }

    void initValueAsLowest(ValueGroup valueGroup) {
        this.type = valueGroup == ValueGroup.UNKNOWN ? GenericLayout.LOWEST_TYPE_BY_VALUE_GROUP : GenericLayout.TYPE_BY_GROUP[valueGroup.ordinal()];
        this.long0 = Long.MIN_VALUE;
        this.long1 = Long.MIN_VALUE;
        this.long2 = Long.MIN_VALUE;
        this.long3 = Long.MIN_VALUE;
        this.byteArray = null;
        if (this.type == GenericLayout.Type.TEXT) {
            this.long3 = 0L;
        }
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    void initValueAsHighest(ValueGroup valueGroup) {
        this.type = valueGroup == ValueGroup.UNKNOWN ? GenericLayout.HIGHEST_TYPE_BY_VALUE_GROUP : GenericLayout.TYPE_BY_GROUP[valueGroup.ordinal()];
        this.long0 = Long.MAX_VALUE;
        this.long1 = Long.MAX_VALUE;
        this.long2 = Long.MAX_VALUE;
        this.long3 = Long.MAX_VALUE;
        this.byteArray = null;
        if (this.type == GenericLayout.Type.TEXT) {
            this.long3 = 1L;
        }
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    void initAsPrefixLow(String prefix) {
        this.writeString(prefix);
        this.long2 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    void initAsPrefixHigh(String prefix) {
        this.writeString(prefix);
        this.long2 = 1L;
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    void copyFrom(GenericKeyState key) {
        this.type = key.type;
        this.inclusion = key.inclusion;
        this.isArray = key.isArray;
        if (!key.isArray) {
            this.long0 = key.long0;
            this.long1 = key.long1;
            this.long2 = key.long2;
            this.long3 = key.long3;
            this.copyByteArrayFromIfExists(key, (int)key.long0);
        } else {
            this.arrayLength = key.arrayLength;
            this.currentArrayOffset = key.currentArrayOffset;
            switch (key.type) {
                case ZONED_DATE_TIME_ARRAY: {
                    this.copyZonedDateTimeArrayFrom(key);
                    break;
                }
                case LOCAL_DATE_TIME_ARRAY: {
                    this.copyLocalDateTimeArrayFrom(key);
                    break;
                }
                case DATE_ARRAY: {
                    this.copyDateArrayFrom(key);
                    break;
                }
                case ZONED_TIME_ARRAY: {
                    this.copyZonedTimeArrayFrom(key);
                    break;
                }
                case LOCAL_TIME_ARRAY: {
                    this.copyLocalTimeArrayFrom(key);
                    break;
                }
                case DURATION_ARRAY: {
                    this.copyDurationArrayFrom(key);
                    break;
                }
                case TEXT_ARRAY: {
                    this.copyTextArrayFrom(key);
                    break;
                }
                case BOOLEAN_ARRAY: {
                    this.copyBooleanArrayFrom(key);
                    break;
                }
                case NUMBER_ARRAY: {
                    this.copyNumberArrayFrom(key);
                    this.long1 = key.long1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Expected an array type but was " + (Object)((Object)this.type));
                }
            }
        }
    }

    private void copyByteArrayFromIfExists(GenericKeyState key, int targetLength) {
        if (key.type == GenericLayout.Type.TEXT) {
            this.setBytesLength(targetLength);
            System.arraycopy(key.byteArray, 0, this.byteArray, 0, targetLength);
        } else {
            this.byteArray = null;
        }
    }

    static Value assertCorrectType(Value value) {
        if (Values.isGeometryValue((Value)value)) {
            throw new IllegalArgumentException("Unsupported value " + value);
        }
        return value;
    }

    void writeValue(Value value, NativeIndexKey.Inclusion inclusion) {
        value.writeTo((ValueWriter)this);
        this.inclusion = inclusion;
    }

    int compareValueTo(GenericKeyState other) {
        int typeComparison = GenericLayout.TYPE_COMPARATOR.compare(this.type, other.type);
        if (typeComparison != 0) {
            return typeComparison;
        }
        int valueComparison = this.internalCompareValueTo(other);
        if (valueComparison != 0) {
            return valueComparison;
        }
        return this.inclusion.compareTo(other.inclusion);
    }

    int size() {
        return this.valueSize() + 1;
    }

    private int valueSize() {
        switch (this.type) {
            case ZONED_DATE_TIME: {
                return 16;
            }
            case LOCAL_DATE_TIME: {
                return 12;
            }
            case DATE: {
                return 8;
            }
            case ZONED_TIME: {
                return 12;
            }
            case LOCAL_TIME: {
                return 8;
            }
            case DURATION: {
                return 28;
            }
            case TEXT: {
                return 2 + (int)this.long0;
            }
            case BOOLEAN: {
                return 1;
            }
            case NUMBER: {
                return 9;
            }
            case ZONED_DATE_TIME_ARRAY: {
                return this.arrayKeySize(16);
            }
            case LOCAL_DATE_TIME_ARRAY: {
                return this.arrayKeySize(12);
            }
            case DATE_ARRAY: {
                return this.arrayKeySize(8);
            }
            case ZONED_TIME_ARRAY: {
                return this.arrayKeySize(12);
            }
            case LOCAL_TIME_ARRAY: {
                return this.arrayKeySize(8);
            }
            case DURATION_ARRAY: {
                return this.arrayKeySize(28);
            }
            case TEXT_ARRAY: {
                int stringArraySize = 0;
                for (int i = 0; i < this.arrayLength; ++i) {
                    stringArraySize += 2 + (int)this.long0Array[i];
                }
                return 4 + stringArraySize;
            }
            case BOOLEAN_ARRAY: {
                return this.arrayKeySize(1);
            }
            case NUMBER_ARRAY: {
                return this.arrayKeySize(8) + 1;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
    }

    private int arrayKeySize(int elementSize) {
        return 4 + this.arrayLength * elementSize;
    }

    Value asValue() {
        switch (this.type) {
            case ZONED_DATE_TIME: {
                return GenericKeyState.zonedDateTimeAsValue(this.long0, this.long1, this.long2, this.long3);
            }
            case LOCAL_DATE_TIME: {
                return GenericKeyState.localDateTimeAsValue(this.long0, this.long1);
            }
            case DATE: {
                return GenericKeyState.dateAsValue(this.long0);
            }
            case ZONED_TIME: {
                return GenericKeyState.zonedTimeAsValue(this.long0, this.long1);
            }
            case LOCAL_TIME: {
                return GenericKeyState.localTimeAsValue(this.long0);
            }
            case DURATION: {
                return GenericKeyState.durationAsValue(this.long0, this.long1, this.long2, this.long3);
            }
            case TEXT: {
                this.long1 = 1L;
                return GenericKeyState.textAsValue(this.byteArray, this.long0);
            }
            case BOOLEAN: {
                return GenericKeyState.booleanAsValue(this.long0);
            }
            case NUMBER: {
                return GenericKeyState.numberAsValue(this.long0, this.long1);
            }
            case ZONED_DATE_TIME_ARRAY: {
                return Values.of((Object)this.populateValueArray(new ZonedDateTime[this.arrayLength], i -> GenericKeyState.zonedDateTimeAsValueRaw(this.long0Array[i], this.long1Array[i], this.long2Array[i], this.long3Array[i])));
            }
            case LOCAL_DATE_TIME_ARRAY: {
                return Values.of((Object)this.populateValueArray(new LocalDateTime[this.arrayLength], i -> GenericKeyState.localDateTimeAsValueRaw(this.long0Array[i], this.long1Array[i])));
            }
            case DATE_ARRAY: {
                return Values.of((Object)this.populateValueArray(new LocalDate[this.arrayLength], i -> GenericKeyState.dateAsValueRaw(this.long0Array[i])));
            }
            case ZONED_TIME_ARRAY: {
                return Values.of((Object)this.populateValueArray(new OffsetTime[this.arrayLength], i -> GenericKeyState.zonedTimeAsValueRaw(this.long0Array[i], this.long1Array[i])));
            }
            case LOCAL_TIME_ARRAY: {
                return Values.of((Object)this.populateValueArray(new LocalTime[this.arrayLength], i -> GenericKeyState.localTimeAsValueRaw(this.long0Array[i])));
            }
            case DURATION_ARRAY: {
                return Values.of((Object)this.populateValueArray(new DurationValue[this.arrayLength], i -> GenericKeyState.durationAsValue(this.long0Array[i], this.long1Array[i], this.long2Array[i], this.long3Array[i])));
            }
            case TEXT_ARRAY: {
                return Values.of((Object)this.populateValueArray(new String[this.arrayLength], i -> GenericKeyState.textAsValueRaw(this.byteArrayArray[i], this.long0Array[i])));
            }
            case BOOLEAN_ARRAY: {
                return this.booleanArrayAsValue();
            }
            case NUMBER_ARRAY: {
                return this.numberArrayAsValue();
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
    }

    private Value numberArrayAsValue() {
        byte numberType = (byte)this.long1;
        switch (numberType) {
            case 0: {
                byte[] byteArray = new byte[this.arrayLength];
                for (int i = 0; i < this.arrayLength; ++i) {
                    byteArray[i] = (byte)this.long0Array[i];
                }
                return Values.byteArray((byte[])byteArray);
            }
            case 1: {
                short[] shortArray = new short[this.arrayLength];
                for (int i = 0; i < this.arrayLength; ++i) {
                    shortArray[i] = (short)this.long0Array[i];
                }
                return Values.shortArray((short[])shortArray);
            }
            case 2: {
                int[] intArray = new int[this.arrayLength];
                for (int i = 0; i < this.arrayLength; ++i) {
                    intArray[i] = (int)this.long0Array[i];
                }
                return Values.intArray((int[])intArray);
            }
            case 3: {
                return Values.longArray((long[])Arrays.copyOf(this.long0Array, this.arrayLength));
            }
            case 4: {
                float[] floatArray = new float[this.arrayLength];
                for (int i = 0; i < this.arrayLength; ++i) {
                    floatArray[i] = Float.intBitsToFloat((int)this.long0Array[i]);
                }
                return Values.floatArray((float[])floatArray);
            }
            case 5: {
                double[] doubleArray = new double[this.arrayLength];
                for (int i = 0; i < this.arrayLength; ++i) {
                    doubleArray[i] = Double.longBitsToDouble(this.long0Array[i]);
                }
                return Values.doubleArray((double[])doubleArray);
            }
        }
        throw new IllegalArgumentException("Unknown number type " + numberType);
    }

    private Value booleanArrayAsValue() {
        boolean[] array = new boolean[this.arrayLength];
        for (int i = 0; i < this.arrayLength; ++i) {
            array[i] = GenericKeyState.booleanAsValueRaw(this.long0Array[i]);
        }
        return Values.of((Object)array);
    }

    private <T> T[] populateValueArray(T[] array, ArrayElementValueFactory<T> valueFactory) {
        for (int i = 0; i < this.arrayLength; ++i) {
            array[i] = valueFactory.from(i);
        }
        return array;
    }

    private int internalCompareValueTo(GenericKeyState that) {
        switch (this.type) {
            case ZONED_DATE_TIME: {
                return GenericKeyState.compareZonedDateTime(this.long0, this.long1, this.long2, this.long3, that.long0, that.long1, that.long2, that.long3);
            }
            case LOCAL_DATE_TIME: {
                return GenericKeyState.compareLocalDateTime(this.long0, this.long1, that.long0, that.long1);
            }
            case DATE: {
                return GenericKeyState.compareDate(this.long0, that.long0);
            }
            case ZONED_TIME: {
                return GenericKeyState.compareZonedTime(this.long0, this.long1, that.long0, that.long1);
            }
            case LOCAL_TIME: {
                return GenericKeyState.compareLocalTime(this.long0, that.long0);
            }
            case DURATION: {
                return GenericKeyState.compareDuration(this.long0, this.long1, this.long2, this.long3, that.long0, that.long1, that.long2, that.long3);
            }
            case TEXT: {
                return GenericKeyState.compareText(this.byteArray, this.long0, this.long2, this.long3, that.byteArray, that.long0, that.long2, that.long3);
            }
            case BOOLEAN: {
                return GenericKeyState.compareBoolean(this.long0, that.long0);
            }
            case NUMBER: {
                return GenericKeyState.compareNumber(this.long0, this.long1, that.long0, that.long1);
            }
            case ZONED_DATE_TIME_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareZonedDateTime(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]));
            }
            case LOCAL_DATE_TIME_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareLocalDateTime(o1.long0Array[i], o1.long1Array[i], o2.long0Array[i], o2.long1Array[i]));
            }
            case DATE_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareDate(o1.long0Array[i], o2.long0Array[i]));
            }
            case ZONED_TIME_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareZonedTime(o1.long0Array[i], o1.long1Array[i], o2.long0Array[i], o2.long1Array[i]));
            }
            case LOCAL_TIME_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareLocalTime(o1.long0Array[i], o2.long0Array[i]));
            }
            case DURATION_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareDuration(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]));
            }
            case TEXT_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareText(o1.byteArrayArray[i], o1.long0Array[i], o1.long2, o1.long3, o2.byteArrayArray[i], o2.long0Array[i], o2.long2, o2.long3));
            }
            case BOOLEAN_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareBoolean(o1.long0Array[i], o2.long0Array[i]));
            }
            case NUMBER_ARRAY: {
                return this.compareArrays(that, (o1, o2, i) -> GenericKeyState.compareNumber(o1.long0Array[i], o1.long1, o2.long0Array[i], o2.long1));
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
    }

    private int compareArrays(GenericKeyState that, ArrayElementComparator comparator) {
        int x = 0;
        int length = Integer.min(this.arrayLength, that.arrayLength);
        for (int i = 0; x == 0 && i < length; ++i) {
            x = comparator.compare(this, that, i);
        }
        return x == 0 ? this.arrayLength - that.arrayLength : x;
    }

    private static int compareNumber(long this_long0, long this_long1, long that_long0, long that_long1) {
        return RawBits.compare(this_long0, (byte)this_long1, that_long0, (byte)that_long1);
    }

    private static int compareBoolean(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    private static int compareText(byte[] this_byteArray, long this_long0, long this_long2, long this_long3, byte[] that_byteArray, long that_long0, long that_long2, long that_long3) {
        if (this_byteArray != that_byteArray) {
            if (this_byteArray == null) {
                return GenericKeyState.isHighestText(this_long3) ? 1 : -1;
            }
            if (that_byteArray == null) {
                return GenericKeyState.isHighestText(that_long3) ? -1 : 1;
            }
        } else {
            return 0;
        }
        return StringIndexKey.lexicographicalUnsignedByteArrayCompare(this_byteArray, (int)this_long0, that_byteArray, (int)that_long0, GenericKeyState.booleanOf(this_long2) | GenericKeyState.booleanOf(that_long2));
    }

    private static int compareZonedDateTime(long this_long0, long this_long1, long this_long2, long this_long3, long that_long0, long that_long1, long that_long2, long that_long3) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0 && (compare = Integer.compare((int)this_long1, (int)that_long1)) == 0 && TimeZones.validZoneOffset((int)((int)this_long3)) && TimeZones.validZoneOffset((int)((int)that_long3))) {
            compare = Values.COMPARATOR.compare((Value)GenericKeyState.zonedDateTimeAsValue(this_long0, this_long1, this_long2, this_long3), (Value)GenericKeyState.zonedDateTimeAsValue(that_long0, that_long1, that_long2, that_long3));
        }
        return compare;
    }

    private static int compareLocalDateTime(long this_long0, long this_long1, long that_long0, long that_long1) {
        int compare = Long.compare(this_long1, that_long1);
        if (compare == 0) {
            compare = Integer.compare((int)this_long0, (int)that_long0);
        }
        return compare;
    }

    private static int compareDate(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    private static int compareZonedTime(long this_long0, long this_long1, long that_long0, long that_long1) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0) {
            compare = Integer.compare((int)this_long1, (int)that_long1);
        }
        return compare;
    }

    private static int compareLocalTime(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    private static int compareDuration(long this_long0, long this_long1, long this_long2, long this_long3, long that_long0, long that_long1, long that_long2, long that_long3) {
        int comparison = Long.compare(this_long0, that_long0);
        if (comparison == 0 && (comparison = Integer.compare((int)this_long1, (int)that_long1)) == 0 && (comparison = Long.compare(this_long2, that_long2)) == 0) {
            comparison = Long.compare(this_long3, that_long3);
        }
        return comparison;
    }

    void put(PageCursor cursor) {
        cursor.putByte(this.type.typeId);
        switch (this.type) {
            case ZONED_DATE_TIME: {
                GenericKeyState.putZonedDateTime(cursor, this.long0, this.long1, this.long2, this.long3);
                break;
            }
            case LOCAL_DATE_TIME: {
                GenericKeyState.putLocalDateTime(cursor, this.long0, this.long1);
                break;
            }
            case DATE: {
                GenericKeyState.putDate(cursor, this.long0);
                break;
            }
            case ZONED_TIME: {
                GenericKeyState.putZonedTime(cursor, this.long0, this.long1);
                break;
            }
            case LOCAL_TIME: {
                GenericKeyState.putLocalTime(cursor, this.long0);
                break;
            }
            case DURATION: {
                GenericKeyState.putDuration(cursor, this.long0, this.long1, this.long2, this.long3);
                break;
            }
            case TEXT: {
                GenericKeyState.putText(cursor, this.byteArray, this.long0);
                break;
            }
            case BOOLEAN: {
                GenericKeyState.putBoolean(cursor, this.long0);
                break;
            }
            case NUMBER: {
                GenericKeyState.putNumber(cursor, this.long0, this.long1);
                break;
            }
            case ZONED_DATE_TIME_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putZonedDateTime(c, this.long0Array[i], this.long1Array[i], this.long2Array[i], this.long3Array[i]));
                break;
            }
            case LOCAL_DATE_TIME_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putLocalDateTime(c, this.long0Array[i], this.long1Array[i]));
                break;
            }
            case DATE_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putDate(c, this.long0Array[i]));
                break;
            }
            case ZONED_TIME_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putZonedTime(c, this.long0Array[i], this.long1Array[i]));
                break;
            }
            case LOCAL_TIME_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putLocalTime(c, this.long0Array[i]));
                break;
            }
            case DURATION_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putDuration(c, this.long0Array[i], this.long1Array[i], this.long2Array[i], this.long3Array[i]));
                break;
            }
            case TEXT_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putText(c, this.byteArrayArray[i], this.long0Array[i]));
                break;
            }
            case BOOLEAN_ARRAY: {
                this.putArray(cursor, (c, i) -> GenericKeyState.putBoolean(c, this.long0Array[i]));
                break;
            }
            case NUMBER_ARRAY: {
                cursor.putByte((byte)this.long1);
                this.putArray(cursor, (c, i) -> c.putLong(this.long0Array[i]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
            }
        }
    }

    private void putArray(PageCursor cursor, ArrayElementWriter writer) {
        cursor.putInt(this.arrayLength);
        for (int i = 0; i < this.arrayLength; ++i) {
            writer.write(cursor, i);
        }
    }

    private static void putNumber(PageCursor cursor, long long0, long long1) {
        cursor.putByte((byte)long1);
        cursor.putLong(long0);
    }

    private static void putBoolean(PageCursor cursor, long long0) {
        cursor.putByte((byte)long0);
    }

    private static void putText(PageCursor cursor, byte[] byteArray, long long0) {
        short length = (short)long0;
        cursor.putShort(length);
        cursor.putBytes(byteArray, 0, (int)length);
    }

    private static void putDuration(PageCursor cursor, long long0, long long1, long long2, long long3) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
        cursor.putLong(long2);
        cursor.putLong(long3);
    }

    private static void putLocalTime(PageCursor cursor, long long0) {
        cursor.putLong(long0);
    }

    private static void putZonedTime(PageCursor cursor, long long0, long long1) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
    }

    private static void putDate(PageCursor cursor, long long0) {
        cursor.putLong(long0);
    }

    private static void putLocalDateTime(PageCursor cursor, long long0, long long1) {
        cursor.putLong(long1);
        cursor.putInt((int)long0);
    }

    private static void putZonedDateTime(PageCursor cursor, long long0, long long1, long long2, long long3) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
        if (long2 >= 0L) {
            cursor.putInt((int)long2 | 0x1000000);
        } else {
            cursor.putInt((int)long3 & 0xFFFFFF);
        }
    }

    boolean read(PageCursor cursor, int size) {
        if (size <= 1) {
            return false;
        }
        byte typeId = cursor.getByte();
        if (typeId < 0 || typeId >= GenericLayout.TYPES.length) {
            return false;
        }
        --size;
        this.type = GenericLayout.TYPE_BY_ID[typeId];
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        switch (this.type) {
            case ZONED_DATE_TIME: {
                return this.readZonedDateTime(cursor);
            }
            case LOCAL_DATE_TIME: {
                return this.readLocalDateTime(cursor);
            }
            case DATE: {
                return this.readDate(cursor);
            }
            case ZONED_TIME: {
                return this.readZonedTime(cursor);
            }
            case LOCAL_TIME: {
                return this.readLocalTime(cursor);
            }
            case DURATION: {
                return this.readDuration(cursor);
            }
            case TEXT: {
                return this.readText(cursor, size);
            }
            case BOOLEAN: {
                return this.readBoolean(cursor);
            }
            case NUMBER: {
                return this.readNumber(cursor);
            }
            case ZONED_DATE_TIME_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.ZONED_DATE_TIME, this::readZonedDateTime);
            }
            case LOCAL_DATE_TIME_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.LOCAL_DATE_TIME, this::readLocalDateTime);
            }
            case DATE_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.DATE, this::readDate);
            }
            case ZONED_TIME_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.ZONED_TIME, this::readZonedTime);
            }
            case LOCAL_TIME_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.LOCAL_TIME, this::readLocalTime);
            }
            case DURATION_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.DURATION, this::readDuration);
            }
            case TEXT_ARRAY: {
                return this.readTextArray(cursor, size);
            }
            case BOOLEAN_ARRAY: {
                return this.readArray(cursor, ValueWriter.ArrayType.BOOLEAN, this::readBoolean);
            }
            case NUMBER_ARRAY: {
                return this.readNumberArray(cursor);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type));
    }

    private boolean readArray(PageCursor cursor, ValueWriter.ArrayType type, ArrayElementReader reader) {
        if (!this.setArrayLengthWhenReading(cursor)) {
            return false;
        }
        this.beginArray(this.arrayLength, type);
        for (int i = 0; i < this.arrayLength; ++i) {
            if (reader.readFrom(cursor)) continue;
            return false;
        }
        this.endArray();
        return true;
    }

    private boolean readNumberArray(PageCursor cursor) {
        this.long1 = cursor.getByte();
        if (!this.setArrayLengthWhenReading(cursor)) {
            return false;
        }
        this.initializeNumberArray(this.arrayLength);
        ValueWriter.ArrayType numberType = GenericKeyState.numberArrayTypeOf((byte)this.long1);
        if (numberType == null) {
            return false;
        }
        this.beginArray(this.arrayLength, numberType);
        for (int i = 0; i < this.arrayLength; ++i) {
            this.long0Array[i] = cursor.getLong();
        }
        this.endArray();
        return true;
    }

    private static ValueWriter.ArrayType numberArrayTypeOf(byte numberType) {
        switch (numberType) {
            case 0: {
                return ValueWriter.ArrayType.BYTE;
            }
            case 1: {
                return ValueWriter.ArrayType.SHORT;
            }
            case 2: {
                return ValueWriter.ArrayType.INT;
            }
            case 3: {
                return ValueWriter.ArrayType.LONG;
            }
            case 4: {
                return ValueWriter.ArrayType.FLOAT;
            }
            case 5: {
                return ValueWriter.ArrayType.DOUBLE;
            }
        }
        return null;
    }

    private boolean readTextArray(PageCursor cursor, int maxSize) {
        if (!this.setArrayLengthWhenReading(cursor)) {
            return false;
        }
        this.beginArray(this.arrayLength, ValueWriter.ArrayType.STRING);
        for (int i = 0; i < this.arrayLength; ++i) {
            short bytesLength = cursor.getShort();
            if (bytesLength <= 0 || bytesLength > maxSize) {
                return false;
            }
            this.byteArrayArray[i] = GenericKeyState.ensureBigEnough(this.byteArrayArray[i], (int)bytesLength);
            this.long0Array[i] = bytesLength;
            cursor.getBytes(this.byteArrayArray[i], 0, (int)bytesLength);
        }
        this.endArray();
        return true;
    }

    private boolean setArrayLengthWhenReading(PageCursor cursor) {
        this.arrayLength = cursor.getInt();
        return this.arrayLength >= 0 && this.arrayLength < 128;
    }

    private boolean readNumber(PageCursor cursor) {
        this.long1 = cursor.getByte();
        this.long0 = cursor.getLong();
        return true;
    }

    private boolean readBoolean(PageCursor cursor) {
        this.writeBoolean((long)cursor.getByte() == 1L);
        return true;
    }

    private boolean readText(PageCursor cursor, int maxSize) {
        short bytesLength = cursor.getShort();
        if (bytesLength <= 0 || bytesLength > maxSize) {
            return false;
        }
        this.setBytesLength(bytesLength);
        cursor.getBytes(this.byteArray, 0, (int)bytesLength);
        return true;
    }

    private boolean readDuration(PageCursor cursor) {
        long totalAvgSeconds = cursor.getLong();
        int nanosOfSecond = cursor.getInt();
        long months = cursor.getLong();
        long days = cursor.getLong();
        this.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanosOfSecond);
        return true;
    }

    private boolean readLocalTime(PageCursor cursor) {
        this.writeLocalTime(cursor.getLong());
        return true;
    }

    private boolean readZonedTime(PageCursor cursor) {
        this.writeTime(cursor.getLong(), cursor.getInt());
        return true;
    }

    private boolean readDate(PageCursor cursor) {
        this.writeDate(cursor.getLong());
        return true;
    }

    private boolean readLocalDateTime(PageCursor cursor) {
        this.writeLocalDateTime(cursor.getLong(), cursor.getInt());
        return true;
    }

    private boolean readZonedDateTime(PageCursor cursor) {
        long epochSecondUTC = cursor.getLong();
        int nanoOfSecond = cursor.getInt();
        int encodedZone = cursor.getInt();
        if (ZonedDateTimeLayout.isZoneId(encodedZone)) {
            this.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeLayout.asZoneId(encodedZone));
        } else {
            this.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeLayout.asZoneOffset(encodedZone));
        }
        return true;
    }

    @Override
    protected void writeDate(long epochDay) throws RuntimeException {
        if (!this.isArray) {
            this.type = GenericLayout.Type.DATE;
            this.long0 = epochDay;
        } else {
            this.long0Array[this.currentArrayOffset] = epochDay;
            ++this.currentArrayOffset;
        }
    }

    @Override
    protected void writeLocalTime(long nanoOfDay) throws RuntimeException {
        if (!this.isArray) {
            this.type = GenericLayout.Type.LOCAL_TIME;
            this.long0 = nanoOfDay;
        } else {
            this.long0Array[this.currentArrayOffset] = nanoOfDay;
            ++this.currentArrayOffset;
        }
    }

    @Override
    protected void writeTime(long nanosOfDayUTC, int offsetSeconds) throws RuntimeException {
        if (!this.isArray) {
            this.type = GenericLayout.Type.ZONED_TIME;
            this.long0 = nanosOfDayUTC;
            this.long1 = offsetSeconds;
        } else {
            this.long0Array[this.currentArrayOffset] = nanosOfDayUTC;
            this.long1Array[this.currentArrayOffset] = offsetSeconds;
            ++this.currentArrayOffset;
        }
    }

    @Override
    protected void writeLocalDateTime(long epochSecond, int nano) throws RuntimeException {
        if (!this.isArray) {
            this.type = GenericLayout.Type.LOCAL_DATE_TIME;
            this.long0 = nano;
            this.long1 = epochSecond;
        } else {
            this.long0Array[this.currentArrayOffset] = nano;
            this.long1Array[this.currentArrayOffset] = epochSecond;
            ++this.currentArrayOffset;
        }
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws RuntimeException {
        this.writeDateTime(epochSecondUTC, nano, (short)-1, offsetSeconds);
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.writeDateTime(epochSecondUTC, nano, TimeZones.map((String)zoneId));
    }

    protected void writeDateTime(long epochSecondUTC, int nano, short zoneId) throws RuntimeException {
        this.writeDateTime(epochSecondUTC, nano, zoneId, 0);
    }

    private void writeDateTime(long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.ZONED_DATE_TIME;
            this.long0 = epochSecondUTC;
            this.long1 = nano;
            this.long2 = zoneId;
            this.long3 = offsetSeconds;
        } else {
            this.long0Array[this.currentArrayOffset] = epochSecondUTC;
            this.long1Array[this.currentArrayOffset] = nano;
            this.long2Array[this.currentArrayOffset] = zoneId;
            this.long3Array[this.currentArrayOffset] = offsetSeconds;
            ++this.currentArrayOffset;
        }
    }

    public void writeBoolean(boolean value) throws RuntimeException {
        if (!this.isArray) {
            this.type = GenericLayout.Type.BOOLEAN;
            this.long0 = value ? 1L : 0L;
        } else {
            this.long0Array[this.currentArrayOffset] = value ? 1L : 0L;
            ++this.currentArrayOffset;
        }
    }

    public void writeInteger(byte value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = value;
            this.long1 = 0L;
        } else {
            this.long0Array[this.currentArrayOffset] = value;
            ++this.currentArrayOffset;
        }
    }

    public void writeInteger(short value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = value;
            this.long1 = 1L;
        } else {
            this.long0Array[this.currentArrayOffset] = value;
            ++this.currentArrayOffset;
        }
    }

    public void writeInteger(int value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = value;
            this.long1 = 2L;
        } else {
            this.long0Array[this.currentArrayOffset] = value;
            ++this.currentArrayOffset;
        }
    }

    public void writeInteger(long value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = value;
            this.long1 = 3L;
        } else {
            this.long0Array[this.currentArrayOffset] = value;
            ++this.currentArrayOffset;
        }
    }

    public void writeFloatingPoint(float value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = Float.floatToIntBits(value);
            this.long1 = 4L;
        } else {
            this.long0Array[this.currentArrayOffset] = Float.floatToIntBits(value);
            ++this.currentArrayOffset;
        }
    }

    public void writeFloatingPoint(double value) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.NUMBER;
            this.long0 = Double.doubleToLongBits(value);
            this.long1 = 5L;
        } else {
            this.long0Array[this.currentArrayOffset] = Double.doubleToLongBits(value);
            ++this.currentArrayOffset;
        }
    }

    public void writeString(String value) throws RuntimeException {
        byte[] encoded = UTF8.encode((String)value);
        if (!this.isArray) {
            this.type = GenericLayout.Type.TEXT;
            this.byteArray = encoded;
            this.long0 = encoded.length;
        } else {
            this.byteArrayArray[this.currentArrayOffset] = encoded;
            this.long0Array[this.currentArrayOffset] = encoded.length;
            ++this.currentArrayOffset;
        }
        this.long1 = 0L;
    }

    public void writeString(char value) throws RuntimeException {
        this.writeString(String.valueOf(value));
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        long totalAvgSeconds = months * 2629800L + days * 86400L + seconds;
        this.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanos);
    }

    private void writeDurationWithTotalAvgSeconds(long months, long days, long totalAvgSeconds, int nanos) {
        if (!this.isArray) {
            this.type = GenericLayout.Type.DURATION;
            this.long0 = totalAvgSeconds;
            this.long1 = nanos;
            this.long2 = months;
            this.long3 = days;
        } else {
            this.long0Array[this.currentArrayOffset] = totalAvgSeconds;
            this.long1Array[this.currentArrayOffset] = nanos;
            this.long2Array[this.currentArrayOffset] = months;
            this.long3Array[this.currentArrayOffset] = days;
            ++this.currentArrayOffset;
        }
    }

    public void writeByteArray(byte[] value) throws RuntimeException {
        PrimitiveArrayWriting.writeTo((ValueWriter)this, (byte[])value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) throws RuntimeException {
        this.initializeTypeFromArrayType(arrayType);
        this.isArray = true;
        this.arrayLength = size;
        this.currentArrayOffset = 0;
        switch (this.type) {
            case ZONED_DATE_TIME_ARRAY: {
                this.initializeZonedDateTimeArray(size);
                break;
            }
            case LOCAL_DATE_TIME_ARRAY: {
                this.initializeLocalDateTimeArray(size);
                break;
            }
            case DATE_ARRAY: {
                this.initializeDateArray(size);
                break;
            }
            case ZONED_TIME_ARRAY: {
                this.initializeZonedTimeArray(size);
                break;
            }
            case LOCAL_TIME_ARRAY: {
                this.initializeLocalTimeArray(size);
                break;
            }
            case DURATION_ARRAY: {
                this.initializeDurationArray(size);
                break;
            }
            case TEXT_ARRAY: {
                this.initializeTextArray(size);
                break;
            }
            case BOOLEAN_ARRAY: {
                this.initializeBooleanArray(size);
                break;
            }
            case NUMBER_ARRAY: {
                this.initializeNumberArray(size);
                break;
            }
        }
    }

    public void endArray() throws RuntimeException {
    }

    private void initializeTypeFromArrayType(ValueWriter.ArrayType arrayType) {
        switch (arrayType) {
            case BYTE: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 0L;
                break;
            }
            case SHORT: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 1L;
                break;
            }
            case INT: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 2L;
                break;
            }
            case LONG: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 3L;
                break;
            }
            case FLOAT: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 4L;
                break;
            }
            case DOUBLE: {
                this.type = GenericLayout.Type.NUMBER_ARRAY;
                this.long1 = 5L;
                break;
            }
            case BOOLEAN: {
                this.type = GenericLayout.Type.BOOLEAN_ARRAY;
                break;
            }
            case STRING: {
                this.type = GenericLayout.Type.TEXT_ARRAY;
                break;
            }
            case CHAR: {
                this.type = GenericLayout.Type.TEXT_ARRAY;
                break;
            }
            case POINT: {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            case ZONED_DATE_TIME: {
                this.type = GenericLayout.Type.ZONED_DATE_TIME_ARRAY;
                break;
            }
            case LOCAL_DATE_TIME: {
                this.type = GenericLayout.Type.LOCAL_DATE_TIME_ARRAY;
                break;
            }
            case DATE: {
                this.type = GenericLayout.Type.DATE_ARRAY;
                break;
            }
            case ZONED_TIME: {
                this.type = GenericLayout.Type.ZONED_TIME_ARRAY;
                break;
            }
            case LOCAL_TIME: {
                this.type = GenericLayout.Type.LOCAL_TIME_ARRAY;
                break;
            }
            case DURATION: {
                this.type = GenericLayout.Type.DURATION_ARRAY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown array type " + arrayType);
            }
        }
    }

    private void initializeNumberArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
    }

    private void initializeBooleanArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
    }

    private void initializeTextArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
        this.byteArrayArray = GenericKeyState.ensureBigEnough(this.byteArrayArray, size);
    }

    private void initializeDurationArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
        this.long1Array = GenericKeyState.ensureBigEnough(this.long1Array, size);
        this.long2Array = GenericKeyState.ensureBigEnough(this.long2Array, size);
        this.long3Array = GenericKeyState.ensureBigEnough(this.long3Array, size);
    }

    private void initializeLocalTimeArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
    }

    private void initializeZonedTimeArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
        this.long1Array = GenericKeyState.ensureBigEnough(this.long1Array, size);
    }

    private void initializeDateArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
    }

    private void initializeLocalDateTimeArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
        this.long1Array = GenericKeyState.ensureBigEnough(this.long1Array, size);
    }

    private void initializeZonedDateTimeArray(int size) {
        this.long0Array = GenericKeyState.ensureBigEnough(this.long0Array, size);
        this.long1Array = GenericKeyState.ensureBigEnough(this.long1Array, size);
        this.long2Array = GenericKeyState.ensureBigEnough(this.long2Array, size);
        this.long3Array = GenericKeyState.ensureBigEnough(this.long3Array, size);
    }

    private void copyNumberArrayFrom(GenericKeyState key) {
        this.initializeNumberArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
    }

    private void copyBooleanArrayFrom(GenericKeyState key) {
        this.initializeBooleanArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
    }

    private void copyTextArrayFrom(GenericKeyState key) {
        this.initializeTextArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
        this.long1 = 0L;
        this.long2 = key.long2;
        this.long3 = key.long3;
        for (int i = 0; i < key.arrayLength; ++i) {
            short targetLength = (short)key.long0Array[i];
            this.byteArrayArray[i] = GenericKeyState.ensureBigEnough(this.byteArrayArray[i], (int)targetLength);
            System.arraycopy(key.byteArrayArray[i], 0, this.byteArrayArray[i], 0, targetLength);
        }
    }

    private void copyDurationArrayFrom(GenericKeyState key) {
        this.initializeDurationArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
        System.arraycopy(key.long1Array, 0, this.long1Array, 0, key.arrayLength);
        System.arraycopy(key.long2Array, 0, this.long2Array, 0, key.arrayLength);
        System.arraycopy(key.long3Array, 0, this.long3Array, 0, key.arrayLength);
    }

    private void copyLocalTimeArrayFrom(GenericKeyState key) {
        this.initializeLocalTimeArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
    }

    private void copyZonedTimeArrayFrom(GenericKeyState key) {
        this.initializeZonedTimeArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
        System.arraycopy(key.long1Array, 0, this.long1Array, 0, key.arrayLength);
    }

    private void copyDateArrayFrom(GenericKeyState key) {
        this.initializeDateArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
    }

    private void copyLocalDateTimeArrayFrom(GenericKeyState key) {
        this.initializeLocalDateTimeArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
        System.arraycopy(key.long1Array, 0, this.long1Array, 0, key.arrayLength);
    }

    private void copyZonedDateTimeArrayFrom(GenericKeyState key) {
        this.initializeZonedDateTimeArray(key.arrayLength);
        System.arraycopy(key.long0Array, 0, this.long0Array, 0, key.arrayLength);
        System.arraycopy(key.long1Array, 0, this.long1Array, 0, key.arrayLength);
        System.arraycopy(key.long2Array, 0, this.long2Array, 0, key.arrayLength);
        System.arraycopy(key.long3Array, 0, this.long3Array, 0, key.arrayLength);
    }

    private void setBytesLength(int length) {
        if (GenericKeyState.booleanOf(this.long1) || this.byteArray == null || this.byteArray.length < length) {
            this.long1 = 0L;
            this.byteArray = new byte[length + length / 2];
        }
        this.long0 = length;
    }

    private static byte[] ensureBigEnough(byte[] array, int targetLength) {
        return array == null || array.length < targetLength ? new byte[targetLength] : array;
    }

    private static byte[][] ensureBigEnough(byte[][] array, int targetLength) {
        return array == null || array.length < targetLength ? new byte[targetLength][] : (byte[][])array;
    }

    private static long[] ensureBigEnough(long[] array, int targetLength) {
        return array == null || array.length < targetLength ? new long[targetLength] : array;
    }

    private static NumberValue numberAsValue(long long0, long long1) {
        return RawBits.asNumberValue(long0, (byte)long1);
    }

    private static BooleanValue booleanAsValue(long long0) {
        return Values.booleanValue((boolean)GenericKeyState.booleanAsValueRaw(long0));
    }

    private static boolean booleanAsValueRaw(long long0) {
        return GenericKeyState.booleanOf(long0);
    }

    private static Value textAsValue(byte[] byteArray, long long0) {
        return byteArray == null ? Values.NO_VALUE : Values.utf8Value((byte[])byteArray, (int)0, (int)((int)long0));
    }

    private static String textAsValueRaw(byte[] byteArray, long long0) {
        return byteArray == null ? null : UTF8.decode((byte[])byteArray, (int)0, (int)((int)long0));
    }

    private static DurationValue durationAsValue(long long0, long long1, long long2, long long3) {
        long seconds = long0 - long2 * 2629800L - long3 * 86400L;
        return DurationValue.duration((long)long2, (long)long3, (long)seconds, (long)long1);
    }

    private static LocalTimeValue localTimeAsValue(long long0) {
        return LocalTimeValue.localTime((LocalTime)GenericKeyState.localTimeAsValueRaw(long0));
    }

    private static LocalTime localTimeAsValueRaw(long long0) {
        return LocalTimeValue.localTimeRaw((long)long0);
    }

    private static Value zonedTimeAsValue(long long0, long long1) {
        OffsetTime time = GenericKeyState.zonedTimeAsValueRaw(long0, long1);
        return time != null ? TimeValue.time((OffsetTime)time) : Values.NO_VALUE;
    }

    private static OffsetTime zonedTimeAsValueRaw(long long0, long long1) {
        if (TimeZones.validZoneOffset((int)((int)long1))) {
            return TimeValue.timeRaw((long)long0, (ZoneOffset)ZoneOffset.ofTotalSeconds((int)long1));
        }
        return null;
    }

    private static DateValue dateAsValue(long long0) {
        return DateValue.date((LocalDate)GenericKeyState.dateAsValueRaw(long0));
    }

    private static LocalDate dateAsValueRaw(long long0) {
        return DateValue.epochDateRaw((long)long0);
    }

    private static LocalDateTimeValue localDateTimeAsValue(long long0, long long1) {
        return LocalDateTimeValue.localDateTime((LocalDateTime)GenericKeyState.localDateTimeAsValueRaw(long0, long1));
    }

    private static LocalDateTime localDateTimeAsValueRaw(long long0, long long1) {
        return LocalDateTimeValue.localDateTimeRaw((long)long1, (long)long0);
    }

    private static DateTimeValue zonedDateTimeAsValue(long long0, long long1, long long2, long long3) {
        return DateTimeValue.datetime((ZonedDateTime)GenericKeyState.zonedDateTimeAsValueRaw(long0, long1, long2, long3));
    }

    private static ZonedDateTime zonedDateTimeAsValueRaw(long long0, long long1, long long2, long long3) {
        return TimeZones.validZoneId((short)((short)long2)) ? DateTimeValue.datetimeRaw((long)long0, (long)long1, (ZoneId)ZoneId.of(TimeZones.map((short)((short)long2)))) : DateTimeValue.datetimeRaw((long)long0, (long)long1, (ZoneOffset)ZoneOffset.ofTotalSeconds((int)long3));
    }

    private static boolean isHighestText(long long3) {
        return long3 == 1L;
    }

    private static boolean booleanOf(long longValue) {
        return longValue == 1L;
    }

    public String toString() {
        return String.format("GenericKeyState[%s]", this.asValue().toString());
    }

    @FunctionalInterface
    static interface ArrayElementValueFactory<T> {
        public T from(int var1);
    }

    @FunctionalInterface
    static interface ArrayElementReader {
        public boolean readFrom(PageCursor var1);
    }

    @FunctionalInterface
    static interface ArrayElementComparator {
        public int compare(GenericKeyState var1, GenericKeyState var2, int var3);
    }

    static interface ArrayElementWriter {
        public void write(PageCursor var1, int var2);
    }
}

