/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;

class GenericNativeIndexAccessor
extends NativeIndexAccessor<CompositeGenericKey, NativeIndexValue> {
    private Validator<Value[]> validator;

    GenericNativeIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<CompositeGenericKey, NativeIndexValue> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        super(pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<CompositeGenericKey, NativeIndexValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), (Layout<CompositeGenericKey, NativeIndexValue>)this.layout);
    }

    @Override
    public IndexReader newReader() {
        return new GenericNativeIndexReader((GBPTree<CompositeGenericKey, NativeIndexValue>)this.tree, (Layout<CompositeGenericKey, NativeIndexValue>)this.layout, this.samplingConfig, this.descriptor);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        this.validator.validate(tuple);
    }
}

