/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class GenericNativeIndexProvider
extends NativeIndexProvider<CompositeGenericKey, NativeIndexValue> {
    public static final GraphDatabaseSettings.SchemaIndex SCHEMA_INDEX = GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10;
    public static final String KEY = SCHEMA_INDEX.providerName();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, SCHEMA_INDEX.providerVersion());
    public static final IndexCapability CAPABILITY = new IndexCapability(){

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            return new IndexOrder[0];
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return null;
        }
    };

    public GenericNativeIndexProvider(int priority, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(DESCRIPTOR, priority, directoryStructureFactory, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    Layout<CompositeGenericKey, NativeIndexValue> layout(StoreIndexDescriptor descriptor) {
        int numberOfSlots = descriptor.properties().length;
        return new GenericLayout(numberOfSlots);
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, Layout<CompositeGenericKey, NativeIndexValue> layout, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new GenericNativeIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, samplingConfig);
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, Layout<CompositeGenericKey, NativeIndexValue> layout, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        return new GenericNativeIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, samplingConfig);
    }

    @Override
    public IndexCapability getCapability() {
        return CAPABILITY;
    }
}

