/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.time.Clock;
import java.util.stream.Stream;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.lock.ResourceType;

public interface Locks {
    public Client newClient();

    public void accept(Visitor var1);

    public void close();

    public static interface Client
    extends ResourceLocker,
    AutoCloseable {
        public static final int NO_LOCK_SESSION_ID = -1;

        public void acquireShared(LockTracer var1, ResourceType var2, long ... var3) throws AcquireLockTimeoutException;

        public void acquireExclusive(LockTracer var1, ResourceType var2, long ... var3) throws AcquireLockTimeoutException;

        public boolean tryExclusiveLock(ResourceType var1, long var2);

        public boolean trySharedLock(ResourceType var1, long var2);

        public boolean reEnterShared(ResourceType var1, long var2);

        public boolean reEnterExclusive(ResourceType var1, long var2);

        public void releaseShared(ResourceType var1, long ... var2);

        public void releaseExclusive(ResourceType var1, long ... var2);

        public void prepare();

        public void stop();

        @Override
        public void close();

        public int getLockSessionId();

        public Stream<? extends ActiveLock> activeLocks();

        public long activeLockCount();
    }

    public static interface Visitor {
        public void visit(ResourceType var1, long var2, String var4, long var5, long var7);
    }

    public static abstract class Factory
    extends Service {
        public Factory(String key, String ... altKeys) {
            super(key, altKeys);
        }

        public abstract Locks newInstance(Config var1, Clock var2, ResourceType[] var3);
    }
}

