/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.BufferingIdGenerator;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;

public class BufferingIdGeneratorFactory
implements IdGeneratorFactory {
    private final BufferingIdGenerator[] overriddenIdGenerators = new BufferingIdGenerator[IdType.values().length];
    private Supplier<KernelTransactionsSnapshot> boundaries;
    private Predicate<KernelTransactionsSnapshot> safeThreshold;
    private final IdGeneratorFactory delegate;
    private final IdTypeConfigurationProvider idTypeConfigurationProvider;

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate, IdReuseEligibility eligibleForReuse, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        this.delegate = delegate;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
        this.safeThreshold = snapshot -> snapshot.allClosed() && eligibleForReuse.isEligible((KernelTransactionsSnapshot)snapshot);
    }

    public void initialize(Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier) {
        this.boundaries = transactionsSnapshotSupplier;
    }

    @Override
    public IdGenerator open(String databaseName, File filename, IdType idType, LongSupplier highId, long maxId) {
        IdTypeConfiguration typeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.open(databaseName, filename, typeConfiguration.getGrabSize(), idType, highId, maxId);
    }

    @Override
    public IdGenerator open(String databaseName, File filename, int grabSize, IdType idType, LongSupplier highId, long maxId) {
        assert (this.boundaries != null) : "Factory needs to be initialized before usage";
        IdGenerator generator = this.delegate.open(databaseName, filename, grabSize, idType, highId, maxId);
        IdTypeConfiguration typeConfiguration = this.getIdTypeConfiguration(idType);
        if (typeConfiguration.allowAggressiveReuse()) {
            BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator);
            bufferingGenerator.initialize(this.boundaries, this.safeThreshold);
            this.overriddenIdGenerators[idType.ordinal()] = bufferingGenerator;
            generator = bufferingGenerator;
        }
        return generator;
    }

    @Override
    public void create(File filename, long highId, boolean throwIfFileExists) {
        this.delegate.create(filename, highId, throwIfFileExists);
    }

    @Override
    public IdGenerator get(IdType idType) {
        BufferingIdGenerator generator = this.overriddenIdGenerators[idType.ordinal()];
        return generator != null ? generator : this.delegate.get(idType);
    }

    public void maintenance() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.maintenance();
        }
    }

    public void clear() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.clear();
        }
    }

    private IdTypeConfiguration getIdTypeConfiguration(IdType idType) {
        return this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
    }
}

