/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class DataSourceManager
implements Lifecycle,
Supplier<Kernel> {
    private LifeSupport life = new LifeSupport();
    private final Listeners<Listener> dsRegistrationListeners = new Listeners();
    private final List<NeoStoreDataSource> dataSources = new ArrayList<NeoStoreDataSource>();

    public void addListener(Listener listener) {
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            try {
                this.dataSources.forEach(listener::registered);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dsRegistrationListeners.add(listener);
    }

    public void register(NeoStoreDataSource dataSource) {
        this.dataSources.add(dataSource);
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            this.life.add((Lifecycle)dataSource);
            this.dsRegistrationListeners.notify(listener -> listener.registered(dataSource));
        }
    }

    public void unregister(NeoStoreDataSource dataSource) {
        this.dataSources.remove((Object)dataSource);
        this.dsRegistrationListeners.notify(listener -> listener.unregistered(dataSource));
        this.life.remove((Lifecycle)dataSource);
    }

    public NeoStoreDataSource getDataSource() {
        return (NeoStoreDataSource)((Object)Iterables.last(this.dataSources));
    }

    public void init() {
        this.life = new LifeSupport();
        this.dataSources.forEach(arg_0 -> ((LifeSupport)this.life).add(arg_0));
    }

    public void start() {
        this.life.start();
        for (Listener listener : this.dsRegistrationListeners) {
            try {
                this.dataSources.forEach(listener::registered);
            }
            catch (Throwable throwable) {}
        }
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
        this.dataSources.clear();
    }

    @Override
    public Kernel get() {
        return this.getDataSource().getKernel();
    }

    public static interface Listener {
        public void registered(NeoStoreDataSource var1);

        public void unregistered(NeoStoreDataSource var1);
    }
}

