/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.Value;

public class DynamicIndexStoreView
implements IndexStoreView {
    private static boolean USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION = FeatureToggles.flag(DynamicIndexStoreView.class, (String)"use.label.index", (boolean)true);
    private final NeoStoreIndexStoreView neoStoreIndexStoreView;
    private final LabelScanStore labelScanStore;
    protected final LockService locks;
    private final Log log;
    protected final NodeStore nodeStore;
    protected final RelationshipStore relationshipStore;
    protected final PropertyStore propertyStore;

    public DynamicIndexStoreView(NeoStoreIndexStoreView neoStoreIndexStoreView, LabelScanStore labelScanStore, LockService locks, NeoStores neoStores, LogProvider logProvider) {
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.neoStoreIndexStoreView = neoStoreIndexStoreView;
        this.locks = locks;
        this.labelScanStore = labelScanStore;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
        if (forceStoreScan || !USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION || this.useAllNodeStoreScan(labelIds)) {
            return this.neoStoreIndexStoreView.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor, forceStoreScan);
        }
        return new LabelScanViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, this.labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor) {
        return new RelationshipStoreScan<FAILURE>(this.relationshipStore, this.locks, this.propertyStore, propertyUpdateVisitor, relationshipTypeIds, propertyKeyIdFilter);
    }

    @Override
    public EntityUpdates nodeAsUpdates(long nodeId) {
        return this.neoStoreIndexStoreView.nodeAsUpdates(nodeId);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId, Register.DoubleLongRegister output) {
        return this.neoStoreIndexStoreView.indexUpdatesAndSize(indexId, output);
    }

    @Override
    public Register.DoubleLongRegister indexSample(long indexId, Register.DoubleLongRegister output) {
        return this.neoStoreIndexStoreView.indexSample(indexId, output);
    }

    @Override
    public void replaceIndexCounts(long indexId, long uniqueElements, long maxUniqueElements, long indexSize) {
        this.neoStoreIndexStoreView.replaceIndexCounts(indexId, uniqueElements, maxUniqueElements, indexSize);
    }

    @Override
    public void incrementIndexUpdates(long indexId, long updatesDelta) {
        this.neoStoreIndexStoreView.incrementIndexUpdates(indexId, updatesDelta);
    }

    private boolean useAllNodeStoreScan(int[] labelIds) {
        try {
            return ArrayUtils.isEmpty((int[])labelIds) || this.isEmptyLabelScanStore();
        }
        catch (Exception e) {
            this.log.error("Can not determine number of labeled nodes, falling back to all nodes scan.", (Throwable)e);
            return true;
        }
    }

    private boolean isEmptyLabelScanStore() throws Exception {
        return this.labelScanStore.isEmpty();
    }

    @Override
    public Value getNodePropertyValue(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.neoStoreIndexStoreView.getNodePropertyValue(nodeId, propertyKeyId);
    }

    @Override
    public void loadProperties(long entityId, EntityType type, MutableIntSet propertyIds, PropertyLoader.PropertyLoadSink sink) {
        this.neoStoreIndexStoreView.loadProperties(entityId, type, propertyIds, sink);
    }
}

