/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.kernel.impl.util.MovingAverage;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.executor.ParkStrategy;
import org.neo4j.unsafe.impl.batchimport.staging.Downstream;
import org.neo4j.unsafe.impl.batchimport.staging.SendDownstream;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.ProcessingStats;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;
import org.neo4j.util.concurrent.WorkSync;

public abstract class AbstractStep<T>
implements Step<T> {
    public static final ParkStrategy PARK = new ParkStrategy.Park(SystemUtils.IS_OS_WINDOWS ? 10000L : 500L, TimeUnit.MICROSECONDS);
    protected final StageControl control;
    private volatile String name;
    protected volatile Step downstream;
    protected volatile WorkSync<Downstream, SendDownstream> downstreamWorkSync;
    private volatile boolean endOfUpstream;
    protected volatile Throwable panic;
    private final CountDownLatch completed = new CountDownLatch(1);
    protected int orderingGuarantees;
    protected final LongAdder downstreamIdleTime = new LongAdder();
    protected final LongAdder upstreamIdleTime = new LongAdder();
    protected final AtomicInteger queuedBatches = new AtomicInteger();
    protected final AtomicLong doneBatches = new AtomicLong();
    protected final MovingAverage totalProcessingTime;
    protected long startTime;
    protected long endTime;
    protected final List<StatsProvider> additionalStatsProvider;
    protected final Runnable healthChecker = this::assertHealthy;
    protected final Configuration config;

    public AbstractStep(StageControl control, String name, Configuration config, StatsProvider ... additionalStatsProvider) {
        this.control = control;
        this.name = name;
        this.config = config;
        this.totalProcessingTime = new MovingAverage(config.movingAverageSize());
        this.additionalStatsProvider = Arrays.asList(additionalStatsProvider);
    }

    @Override
    public void start(int orderingGuarantees) {
        this.orderingGuarantees = orderingGuarantees;
        this.resetStats();
    }

    protected boolean guarantees(int orderingGuaranteeFlag) {
        return (this.orderingGuarantees & orderingGuaranteeFlag) != 0;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void receivePanic(Throwable cause) {
        this.panic = cause;
    }

    protected boolean stillWorking() {
        if (this.isPanic()) {
            return false;
        }
        return !this.endOfUpstream || this.queuedBatches.get() != 0;
    }

    protected boolean isPanic() {
        return this.panic != null;
    }

    @Override
    public boolean isCompleted() {
        return this.completed.getCount() == 0L;
    }

    @Override
    public void awaitCompleted() throws InterruptedException {
        this.completed.await();
    }

    protected void issuePanic(Throwable cause) {
        this.issuePanic(cause, true);
    }

    protected void issuePanic(Throwable cause, boolean rethrow) {
        this.control.panic(cause);
        if (rethrow) {
            throw new RuntimeException(cause);
        }
    }

    protected void assertHealthy() {
        if (this.isPanic()) {
            throw new RuntimeException(this.panic);
        }
    }

    @Override
    public void setDownstream(Step<?> downstream) {
        assert (downstream != this);
        this.downstream = downstream;
        this.downstreamWorkSync = new WorkSync((Object)new Downstream(downstream, this.doneBatches));
    }

    @Override
    public StepStats stats() {
        ArrayList<StatsProvider> providers = new ArrayList<StatsProvider>();
        this.collectStatsProviders(providers);
        return new StepStats(this.name, this.stillWorking(), providers);
    }

    protected void collectStatsProviders(Collection<StatsProvider> into) {
        into.add(new ProcessingStats(this.doneBatches.get() + (long)this.queuedBatches.get(), this.doneBatches.get(), this.totalProcessingTime.total(), this.totalProcessingTime.average() / (long)this.processors(0), this.upstreamIdleTime.sum(), this.downstreamIdleTime.sum()));
        into.addAll(this.additionalStatsProvider);
    }

    @Override
    public void endOfUpstream() {
        this.endOfUpstream = true;
        this.checkNotifyEndDownstream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNotifyEndDownstream() {
        if (!this.stillWorking() && !this.isCompleted()) {
            AbstractStep abstractStep = this;
            synchronized (abstractStep) {
                if (!this.isCompleted()) {
                    this.done();
                    if (this.downstream != null) {
                        this.downstream.endOfUpstream();
                    }
                    this.endTime = System.currentTimeMillis();
                    this.completed.countDown();
                }
            }
        }
    }

    protected void done() {
    }

    @Override
    public void close() throws Exception {
    }

    protected void changeName(String name) {
        this.name = name;
    }

    protected void resetStats() {
        this.downstreamIdleTime.reset();
        this.upstreamIdleTime.reset();
        this.queuedBatches.set(0);
        this.doneBatches.set(0L);
        this.totalProcessingTime.reset();
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public String toString() {
        return String.format("%s[%s, processors:%d, batches:%d", this.getClass().getSimpleName(), this.name, this.processors(0), this.doneBatches.get());
    }
}

