/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.index.EntityCommandGrouper;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.CommandsToApply;

public class PropertyCommandsExtractor
extends TransactionApplier.Adapter
implements BatchTransactionApplier {
    private final EntityCommandGrouper<Command.NodeCommand> nodeCommands = new EntityCommandGrouper<Command.NodeCommand>(Command.NodeCommand.class, 16);
    private final EntityCommandGrouper<Command.RelationshipCommand> relationshipCommands = new EntityCommandGrouper<Command.RelationshipCommand>(Command.RelationshipCommand.class, 16);
    private boolean hasUpdates;

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        return this;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, LockGroup lockGroup) {
        return this.startTx(transaction);
    }

    @Override
    public void close() {
        this.nodeCommands.clear();
        this.relationshipCommands.clear();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.nodeCommands.add(command);
        if (!this.hasUpdates && PropertyCommandsExtractor.mayResultInIndexUpdates(command)) {
            this.hasUpdates = true;
        }
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.relationshipCommands.add(command);
        this.hasUpdates = true;
        return false;
    }

    private static boolean mayResultInIndexUpdates(Command.NodeCommand command) {
        long after;
        long before = ((NodeRecord)command.getBefore()).getLabelField();
        return before != (after = ((NodeRecord)command.getAfter()).getLabelField()) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(after);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (((PropertyRecord)command.getAfter()).isNodeSet()) {
            this.nodeCommands.add(command);
            this.hasUpdates = true;
        } else if (((PropertyRecord)command.getAfter()).isRelSet()) {
            this.relationshipCommands.add(command);
            this.hasUpdates = true;
        }
        return false;
    }

    public boolean containsAnyEntityOrPropertyUpdate() {
        return this.hasUpdates;
    }

    public EntityCommandGrouper.Cursor getNodeCommands() {
        return this.nodeCommands.sortAndAccessGroups();
    }

    public EntityCommandGrouper.Cursor getRelationshipCommands() {
        return this.relationshipCommands.sortAndAccessGroups();
    }
}

