/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ExplicitIndexProxy<T extends PropertyContainer>
implements Index<T> {
    public static final Type NODE = new Type<Node>(){

        @Override
        public Class<Node> getEntityType() {
            return Node.class;
        }

        @Override
        public Node entity(long id, GraphDatabaseService graphDatabaseService) {
            return graphDatabaseService.getNodeById(id);
        }

        @Override
        public IndexHits<Node> get(KernelTransaction ktx, String name, String key, Object value, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            NodeExplicitIndexCursor cursor = ktx.cursors().allocateNodeExplicitIndexCursor();
            ktx.indexRead().nodeExplicitIndexLookup(cursor, name, key, value);
            return new CursorWrappingNodeIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public IndexHits<Node> query(KernelTransaction ktx, String name, String key, Object queryOrQueryObject, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            NodeExplicitIndexCursor cursor = ktx.cursors().allocateNodeExplicitIndexCursor();
            ktx.indexRead().nodeExplicitIndexQuery(cursor, name, key, queryOrQueryObject);
            return new CursorWrappingNodeIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public IndexHits<Node> query(KernelTransaction ktx, String name, Object queryOrQueryObject, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            NodeExplicitIndexCursor cursor = ktx.cursors().allocateNodeExplicitIndexCursor();
            ktx.indexRead().nodeExplicitIndexQuery(cursor, name, queryOrQueryObject);
            return new CursorWrappingNodeIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public void add(ExplicitIndexWrite operations, String name, long id, String key, Object value) throws ExplicitIndexNotFoundKernelException {
            operations.nodeAddToExplicitIndex(name, id, key, value);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id, String key, Object value) throws ExplicitIndexNotFoundKernelException {
            operations.nodeRemoveFromExplicitIndex(name, id, key, value);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id, String key) throws ExplicitIndexNotFoundKernelException {
            operations.nodeRemoveFromExplicitIndex(name, id, key);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id) throws ExplicitIndexNotFoundKernelException {
            operations.nodeRemoveFromExplicitIndex(name, id);
        }

        @Override
        public void drop(ExplicitIndexWrite operations, String name) throws ExplicitIndexNotFoundKernelException {
            operations.nodeExplicitIndexDrop(name);
        }

        @Override
        public long id(PropertyContainer entity) {
            return ((Node)entity).getId();
        }
    };
    public static final Type RELATIONSHIP = new Type<Relationship>(){

        @Override
        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }

        @Override
        public Relationship entity(long id, GraphDatabaseService graphDatabaseService) {
            return graphDatabaseService.getRelationshipById(id);
        }

        @Override
        public IndexHits<Relationship> get(KernelTransaction ktx, String name, String key, Object value, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            ktx.indexRead().relationshipExplicitIndexLookup(cursor, name, key, value, -1L, -1L);
            return new CursorWrappingRelationshipIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public IndexHits<Relationship> query(KernelTransaction ktx, String name, String key, Object queryOrQueryObject, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            ktx.indexRead().relationshipExplicitIndexQuery(cursor, name, key, queryOrQueryObject, -1L, -1L);
            return new CursorWrappingRelationshipIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public IndexHits<Relationship> query(KernelTransaction ktx, String name, Object queryOrQueryObject, GraphDatabaseService graphDatabaseService) throws ExplicitIndexNotFoundKernelException {
            RelationshipExplicitIndexCursor cursor = ktx.cursors().allocateRelationshipExplicitIndexCursor();
            ktx.indexRead().relationshipExplicitIndexQuery(cursor, name, queryOrQueryObject, -1L, -1L);
            return new CursorWrappingRelationshipIndexHits(cursor, graphDatabaseService, ktx, name);
        }

        @Override
        public void add(ExplicitIndexWrite operations, String name, long id, String key, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
            operations.relationshipAddToExplicitIndex(name, id, key, value);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id, String key, Object value) throws ExplicitIndexNotFoundKernelException {
            operations.relationshipRemoveFromExplicitIndex(name, id, key, value);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id, String key) throws ExplicitIndexNotFoundKernelException {
            operations.relationshipRemoveFromExplicitIndex(name, id, key);
        }

        @Override
        public void remove(ExplicitIndexWrite operations, String name, long id) throws ExplicitIndexNotFoundKernelException {
            operations.relationshipRemoveFromExplicitIndex(name, id);
        }

        @Override
        public void drop(ExplicitIndexWrite operations, String name) throws ExplicitIndexNotFoundKernelException {
            operations.relationshipExplicitIndexDrop(name);
        }

        @Override
        public long id(PropertyContainer entity) {
            return ((Relationship)entity).getId();
        }
    };
    protected final String name;
    protected final Type<T> type;
    protected final Supplier<KernelTransaction> txBridge;
    private final GraphDatabaseService gds;

    public ExplicitIndexProxy(String name, Type<T> type, GraphDatabaseService gds, Supplier<KernelTransaction> txBridge) {
        this.name = name;
        this.type = type;
        this.gds = gds;
        this.txBridge = txBridge;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getEntityType() {
        return this.type.getEntityType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> get(String key, Object value) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            IndexHits<T> indexHits = this.internalGet(key, value, ktx);
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    private IndexHits<T> internalGet(String key, Object value, KernelTransaction ktx) throws ExplicitIndexNotFoundKernelException {
        return this.type.get(ktx, this.name, key, value, this.gds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> query(String key, Object queryOrQueryObject) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            IndexHits<T> indexHits = this.type.query(ktx, this.name, key, queryOrQueryObject, this.gds);
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> query(Object queryOrQueryObject) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            IndexHits<T> indexHits = this.type.query(ktx, this.name, queryOrQueryObject, this.gds);
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    public boolean isWriteable() {
        return true;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.gds;
    }

    public void add(T entity, String key, Object value) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            this.internalAdd(entity, key, value, ktx);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", this.type, this.type.id((PropertyContainer)entity)), (Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    public void remove(T entity, String key, Object value) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            this.type.remove(ktx.indexWrite(), this.name, this.type.id((PropertyContainer)entity), key, value);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    public void remove(T entity, String key) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            this.type.remove(ktx.indexWrite(), this.name, this.type.id((PropertyContainer)entity), key);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    public void remove(T entity) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            this.internalRemove(ktx, this.type.id((PropertyContainer)entity));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    private void internalRemove(KernelTransaction ktx, long id) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
        this.type.remove(ktx.indexWrite(), this.name, id);
    }

    public void delete() {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            this.type.drop(ktx.indexWrite(), this.name);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(this.type + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T putIfAbsent(T entity, String key, Object value) {
        KernelTransaction ktx = this.txBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            PropertyContainer existing = (PropertyContainer)Iterators.single(this.internalGet(key, value, ktx), null);
            if (existing != null) {
                PropertyContainer propertyContainer = existing;
                return (T)propertyContainer;
            }
            ktx.locks().acquireExclusiveExplicitIndexLock(new long[]{ResourceTypes.explicitIndexResourceId(this.name, key)});
            existing = (PropertyContainer)Iterators.single(this.internalGet(key, value, ktx), null);
            if (existing != null) {
                ktx.locks().releaseExclusiveExplicitIndexLock(new long[]{ResourceTypes.explicitIndexResourceId(this.name, key)});
                PropertyContainer propertyContainer = existing;
                return (T)propertyContainer;
            }
            this.internalAdd(entity, key, value, ktx);
            T t = null;
            return t;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", this.type, this.type.id((PropertyContainer)entity)), (Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalAdd(T entity, String key, Object value, KernelTransaction transaction) throws EntityNotFoundException, InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
        this.type.add(transaction.indexWrite(), this.name, this.type.id((PropertyContainer)entity), key, value);
    }

    public String toString() {
        return "Index[" + this.type + ", " + this.name + "]";
    }

    protected static class CursorWrappingRelationshipIndexHits
    extends AbstractCursorWrappingIndexHits<Relationship> {
        private final RelationshipExplicitIndexCursor cursor;
        private final GraphDatabaseService graphDatabaseService;
        private final KernelTransaction ktx;
        private final String name;

        CursorWrappingRelationshipIndexHits(RelationshipExplicitIndexCursor cursor, GraphDatabaseService graphDatabaseService, KernelTransaction ktx, String name) {
            super(cursor.expectedTotalNumberOfResults(), cursor.score());
            this.cursor = cursor;
            this.graphDatabaseService = graphDatabaseService;
            this.ktx = ktx;
            this.name = name;
        }

        public void close() {
            this.cursor.close();
        }

        @Override
        protected long fetchNext() {
            this.ktx.assertOpen();
            while (this.cursor.next()) {
                long reference = this.cursor.relationshipReference();
                if (this.ktx.dataRead().relationshipExists(reference)) {
                    return reference;
                }
                if (!this.ktx.securityContext().mode().allowsWrites()) continue;
                try {
                    RELATIONSHIP.remove(this.ktx.indexWrite(), this.name, reference);
                }
                catch (InvalidTransactionTypeKernelException | ExplicitIndexNotFoundKernelException throwable) {}
            }
            this.close();
            return -1L;
        }

        @Override
        protected Relationship materialize(long id) {
            this.score = this.cursor.score();
            this.size = this.cursor.expectedTotalNumberOfResults();
            return this.graphDatabaseService.getRelationshipById(id);
        }
    }

    private static class CursorWrappingNodeIndexHits
    extends AbstractCursorWrappingIndexHits<Node> {
        private final NodeExplicitIndexCursor cursor;
        private final GraphDatabaseService graphDatabaseService;
        private final KernelTransaction ktx;
        private final String name;

        private CursorWrappingNodeIndexHits(NodeExplicitIndexCursor cursor, GraphDatabaseService graphDatabaseService, KernelTransaction ktx, String name) {
            super(cursor.expectedTotalNumberOfResults(), cursor.score());
            this.cursor = cursor;
            this.graphDatabaseService = graphDatabaseService;
            this.ktx = ktx;
            this.name = name;
        }

        public void close() {
            this.cursor.close();
        }

        @Override
        protected long fetchNext() {
            this.ktx.assertOpen();
            while (this.cursor.next()) {
                long reference = this.cursor.nodeReference();
                if (this.ktx.dataRead().nodeExists(reference)) {
                    return reference;
                }
                if (!this.ktx.securityContext().mode().allowsWrites()) continue;
                try {
                    NODE.remove(this.ktx.indexWrite(), this.name, reference);
                }
                catch (InvalidTransactionTypeKernelException | ExplicitIndexNotFoundKernelException throwable) {}
            }
            this.close();
            return -1L;
        }

        @Override
        protected Node materialize(long id) {
            this.score = this.cursor.score();
            this.size = this.cursor.expectedTotalNumberOfResults();
            return this.graphDatabaseService.getNodeById(id);
        }
    }

    private static abstract class AbstractCursorWrappingIndexHits<T extends PropertyContainer>
    implements IndexHits<T> {
        private static final long NOT_INITIALIZED = -2L;
        static final long NO_ID = -1L;
        private long next = -2L;
        protected int size;
        protected float score;

        AbstractCursorWrappingIndexHits(int size, float score) {
            this.size = size;
            this.score = score;
        }

        public ResourceIterator<T> iterator() {
            return this;
        }

        public int size() {
            return this.size;
        }

        public float currentScore() {
            return this.score;
        }

        public T getSingle() {
            if (!this.hasNext()) {
                return null;
            }
            T item = this.next();
            if (this.hasNext()) {
                throw new NoSuchElementException();
            }
            return item;
        }

        public boolean hasNext() {
            if (this.next == -2L) {
                this.next = this.fetchNext();
            }
            return this.next != -1L;
        }

        public T next() {
            if (!this.hasNext()) {
                this.close();
                throw new NoSuchElementException();
            }
            T item = this.materialize(this.next);
            this.next = -2L;
            return item;
        }

        protected abstract long fetchNext();

        protected abstract T materialize(long var1);
    }

    static interface Type<T extends PropertyContainer> {
        public Class<T> getEntityType();

        public T entity(long var1, GraphDatabaseService var3);

        public IndexHits<T> get(KernelTransaction var1, String var2, String var3, Object var4, GraphDatabaseService var5) throws ExplicitIndexNotFoundKernelException;

        public IndexHits<T> query(KernelTransaction var1, String var2, String var3, Object var4, GraphDatabaseService var5) throws ExplicitIndexNotFoundKernelException;

        public IndexHits<T> query(KernelTransaction var1, String var2, Object var3, GraphDatabaseService var4) throws ExplicitIndexNotFoundKernelException;

        public void add(ExplicitIndexWrite var1, String var2, long var3, String var5, Object var6) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException;

        public void remove(ExplicitIndexWrite var1, String var2, long var3, String var5, Object var6) throws ExplicitIndexNotFoundKernelException;

        public void remove(ExplicitIndexWrite var1, String var2, long var3, String var5) throws ExplicitIndexNotFoundKernelException;

        public void remove(ExplicitIndexWrite var1, String var2, long var3) throws ExplicitIndexNotFoundKernelException;

        public void drop(ExplicitIndexWrite var1, String var2) throws ExplicitIndexNotFoundKernelException;

        public long id(PropertyContainer var1);
    }
}

