/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.neo4j.helpers.Format;
import org.neo4j.internal.diagnostics.DiagnosticsPhase;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Logger;
import org.neo4j.storageengine.api.StoreId;

public abstract class KernelDiagnostics
implements DiagnosticsProvider {
    public String getDiagnosticsIdentifier() {
        return this.getClass().getDeclaringClass().getSimpleName() + ":" + this.getClass().getSimpleName();
    }

    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    public void dump(DiagnosticsPhase phase, Logger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            this.dump(log);
        }
    }

    abstract void dump(Logger var1);

    public static class StoreFiles
    extends KernelDiagnostics {
        private final DatabaseLayout databaseLayout;
        private static String FORMAT_DATE_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
        private final SimpleDateFormat dateFormat;

        public StoreFiles(DatabaseLayout databaseLayout) {
            this.databaseLayout = databaseLayout;
            TimeZone tz = TimeZone.getDefault();
            this.dateFormat = new SimpleDateFormat(FORMAT_DATE_ISO);
            this.dateFormat.setTimeZone(tz);
        }

        @Override
        void dump(Logger logger) {
            logger.log(StoreFiles.getDiskSpace(this.databaseLayout));
            logger.log("Storage files: (filename : modification date - size)");
            MappedFileCounter mappedCounter = new MappedFileCounter(this.databaseLayout);
            long totalSize = this.logStoreFiles(logger, "  ", this.databaseLayout.databaseDirectory(), mappedCounter);
            logger.log("Storage summary: ");
            logger.log("  Total size of store: " + Format.bytes(totalSize));
            logger.log("  Total size of mapped files: " + Format.bytes(mappedCounter.getSize()));
        }

        private long logStoreFiles(Logger logger, String prefix, File dir, MappedFileCounter mappedCounter) {
            if (!dir.isDirectory()) {
                return 0L;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                logger.log(prefix + "<INACCESSIBLE>");
                return 0L;
            }
            long total = 0L;
            List<File> fileList = Arrays.asList(files);
            fileList.sort(Comparator.comparing(File::getName));
            for (File file : fileList) {
                long size;
                String filename = file.getName();
                if (file.isDirectory()) {
                    logger.log(prefix + filename + ":");
                    size = this.logStoreFiles(logger, prefix + "  ", file, mappedCounter);
                    filename = "- Total";
                } else {
                    size = file.length();
                    mappedCounter.addFile(file);
                }
                String fileModificationDate = this.getFileModificationDate(file);
                String bytes = Format.bytes(size);
                String fileInformation = String.format("%s%s: %s - %s", prefix, filename, fileModificationDate, bytes);
                logger.log(fileInformation);
                total += size;
            }
            return total;
        }

        private String getFileModificationDate(File file) {
            Date modifiedDate = new Date(file.lastModified());
            return this.dateFormat.format(modifiedDate);
        }

        private static String getDiskSpace(DatabaseLayout databaseLayout) {
            File directory = databaseLayout.databaseDirectory();
            long free = directory.getFreeSpace();
            long total = directory.getTotalSpace();
            long percentage = total != 0L ? free * 100L / total : 0L;
            return String.format("Disk space on partition (Total / Free / Free %%): %s / %s / %s", total, free, percentage);
        }

        private static class MappedFileCounter {
            private final DatabaseLayout layout;
            private final FileFilter mappedIndexFilter;
            private long size;
            private final List<File> mappedCandidates;

            MappedFileCounter(DatabaseLayout layout) {
                this.layout = layout;
                this.mappedCandidates = Arrays.stream(StoreType.values()).filter(StoreType::isRecordStore).map(StoreType::getDatabaseFile).flatMap(arg_0 -> ((DatabaseLayout)layout).file(arg_0)).collect(Collectors.toList());
                this.mappedIndexFilter = new NativeIndexFileFilter(layout.databaseDirectory());
            }

            void addFile(File file) {
                if (this.canBeManagedByPageCache(file) || this.mappedIndexFilter.accept(file)) {
                    this.size += file.length();
                }
            }

            public long getSize() {
                return this.size;
            }

            boolean canBeManagedByPageCache(File storeFile) {
                boolean isLabelScanStore = this.layout.labelScanStore().equals(storeFile);
                return isLabelScanStore || this.mappedCandidates.contains(storeFile);
            }
        }
    }

    public static class Versions
    extends KernelDiagnostics {
        private final DatabaseInfo databaseInfo;
        private final StoreId storeId;

        public Versions(DatabaseInfo databaseInfo, StoreId storeId) {
            this.databaseInfo = databaseInfo;
            this.storeId = storeId;
        }

        @Override
        void dump(Logger logger) {
            logger.log("Graph Database: " + this.databaseInfo + " " + this.storeId);
            logger.log("Kernel version: " + Version.getKernelVersion());
        }
    }
}

