/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class DefaultPropertyCursor
implements PropertyCursor {
    private Read read;
    private StoragePropertyCursor storeCursor;
    private PropertyContainerState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private AssertOpen assertOpen;
    private final DefaultCursors pool;

    DefaultPropertyCursor(DefaultCursors pool, StoragePropertyCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void initNode(long nodeReference, long reference, Read read, AssertOpen assertOpen) {
        assert (nodeReference != -1L);
        this.init(reference, nodeReference, EntityType.NODE, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        }
    }

    void initRelationship(long relationshipReference, long reference, Read read, AssertOpen assertOpen) {
        assert (relationshipReference != -1L);
        this.init(reference, relationshipReference, EntityType.RELATIONSHIP, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        }
    }

    void initGraph(long reference, Read read, AssertOpen assertOpen) {
        this.init(reference, -1L, EntityType.GRAPH, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getGraphState();
            if (this.propertiesState != null) {
                this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
            }
        }
    }

    private void init(long reference, long ownerReference, EntityType ownerType, Read read, AssertOpen assertOpen) {
        this.assertOpen = assertOpen;
        this.read = read;
        this.storeCursor.init(reference, ownerReference, ownerType);
    }

    public boolean next() {
        boolean hasNext;
        while ((hasNext = this.innerNext()) && !this.allowed(this.propertyKey())) {
        }
        return hasNext;
    }

    private boolean allowed(int propertyKey) {
        return this.read.ktx.securityContext().mode().allowsPropertyReads(propertyKey);
    }

    private boolean innerNext() {
        if (this.txStateChangedProperties != null) {
            if (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            boolean skip = this.propertiesState != null && this.propertiesState.isPropertyChangedOrRemoved(this.storeCursor.propertyKey());
            if (skip) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            this.pool.accept(this);
        }
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.storeCursor.propertyValue();
        this.assertOpen.assertOpen();
        return value;
    }

    public <E extends Exception> void writeTo(ValueWriter<E> target) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean booleanValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String stringValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long longValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public double doubleValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(long value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(double value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(String value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueMatches(Pattern regex) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThan(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThan(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThan(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThan(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThanOrEqualTo(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThanOrEqualTo(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThanOrEqualTo(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThanOrEqualTo(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + this.storeCursor.toString() + " ]";
    }

    public void release() {
        this.storeCursor.close();
    }
}

