/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.FeatureToggles;

public class IndexSamplingController {
    private final IndexSamplingJobFactory jobFactory;
    private final IndexSamplingJobQueue<Long> jobQueue;
    private final IndexSamplingJobTracker jobTracker;
    private final IndexMapSnapshotProvider indexMapSnapshotProvider;
    private final JobScheduler scheduler;
    private final RecoveryCondition indexRecoveryCondition;
    private final boolean backgroundSampling;
    private final Lock samplingLock = new ReentrantLock();
    private final Log log;
    static final String LOG_RECOVER_INDEX_SAMPLES_NAME = "log_recover_index_samples";
    static final String ASYNC_RECOVER_INDEX_SAMPLES_NAME = "async_recover_index_samples";
    static final String ASYNC_RECOVER_INDEX_SAMPLES_WAIT_NAME = "async_recover_index_samples_wait";
    private final boolean logRecoverIndexSamples;
    private final boolean asyncRecoverIndexSamples;
    private final boolean asyncRecoverIndexSamplesWait;
    private JobHandle backgroundSamplingHandle;

    IndexSamplingController(IndexSamplingConfig config, IndexSamplingJobFactory jobFactory, IndexSamplingJobQueue<Long> jobQueue, IndexSamplingJobTracker jobTracker, IndexMapSnapshotProvider indexMapSnapshotProvider, JobScheduler scheduler, RecoveryCondition indexRecoveryCondition, LogProvider logProvider) {
        this.backgroundSampling = config.backgroundSampling();
        this.jobFactory = jobFactory;
        this.indexMapSnapshotProvider = indexMapSnapshotProvider;
        this.jobQueue = jobQueue;
        this.jobTracker = jobTracker;
        this.scheduler = scheduler;
        this.indexRecoveryCondition = indexRecoveryCondition;
        this.log = logProvider.getLog(this.getClass());
        this.logRecoverIndexSamples = FeatureToggles.flag(IndexSamplingController.class, (String)LOG_RECOVER_INDEX_SAMPLES_NAME, (boolean)false);
        this.asyncRecoverIndexSamples = FeatureToggles.flag(IndexSamplingController.class, (String)ASYNC_RECOVER_INDEX_SAMPLES_NAME, (boolean)false);
        this.asyncRecoverIndexSamplesWait = FeatureToggles.flag(IndexSamplingController.class, (String)ASYNC_RECOVER_INDEX_SAMPLES_WAIT_NAME, (boolean)this.asyncRecoverIndexSamples);
    }

    public void sampleIndexes(IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.addAll(!mode.sampleOnlyIfUpdated, PrimitiveLongCollections.toIterator((LongIterator)indexMap.indexIds()));
        this.scheduleSampling(mode, indexMap);
    }

    public void sampleIndex(long indexId, IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.add(!mode.sampleOnlyIfUpdated, indexId);
        this.scheduleSampling(mode, indexMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIndexSamples() {
        this.samplingLock.lock();
        try {
            IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
            LongIterator indexIds = indexMap.indexIds();
            ArrayList<IndexSamplingJobHandle> asyncSamplingJobs = new ArrayList<IndexSamplingJobHandle>();
            while (indexIds.hasNext()) {
                long indexId = indexIds.next();
                CapableIndexDescriptor descriptor = indexMap.getIndexProxy(indexId).getDescriptor();
                if (this.indexRecoveryCondition.test((StoreIndexDescriptor)descriptor)) {
                    if (this.logRecoverIndexSamples) {
                        this.log.info("Index requires sampling, id=%d, name=%s.", new Object[]{indexId, descriptor.getName()});
                    }
                    if (this.asyncRecoverIndexSamples) {
                        asyncSamplingJobs.add(this.sampleIndexOnTracker(indexMap, indexId));
                        continue;
                    }
                    this.sampleIndexOnCurrentThread(indexMap, indexId);
                    continue;
                }
                if (!this.logRecoverIndexSamples) continue;
                this.log.info("Index does not require sampling, id=%d, name=%s.", new Object[]{indexId, descriptor.getName()});
            }
            if (this.asyncRecoverIndexSamplesWait) {
                this.waitForAsyncIndexSamples(asyncSamplingJobs);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void waitForAsyncIndexSamples(List<IndexSamplingJobHandle> asyncSamplingJobs) {
        for (IndexSamplingJobHandle asyncSamplingJob : asyncSamplingJobs) {
            try {
                asyncSamplingJob.jobHandle.waitTermination();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to asynchronously sample index during recovery, index: " + asyncSamplingJob.indexSamplingJob.indexId(), e);
            }
        }
    }

    private void scheduleSampling(IndexSamplingMode mode, IndexMap indexMap) {
        if (mode.blockUntilAllScheduled) {
            this.scheduleAllSampling(indexMap);
        } else {
            this.tryScheduleSampling(indexMap);
        }
    }

    private void tryScheduleSampling(IndexMap indexMap) {
        if (this.tryEmptyLock()) {
            try {
                while (this.jobTracker.canExecuteMoreSamplingJobs()) {
                    Long indexId = this.jobQueue.poll();
                    if (indexId == null) {
                        return;
                    }
                    this.sampleIndexOnTracker(indexMap, indexId);
                }
            }
            finally {
                this.samplingLock.unlock();
            }
        }
    }

    private boolean tryEmptyLock() {
        try {
            return this.samplingLock.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAllSampling(IndexMap indexMap) {
        this.samplingLock.lock();
        try {
            Iterable<Long> indexIds = this.jobQueue.pollAll();
            for (Long indexId : indexIds) {
                this.jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                this.sampleIndexOnTracker(indexMap, indexId);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private IndexSamplingJobHandle sampleIndexOnTracker(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        if (job != null) {
            return new IndexSamplingJobHandle(job, this.jobTracker.scheduleSamplingJob(job));
        }
        return new IndexSamplingJobHandle(job, JobHandle.nullInstance);
    }

    private void sampleIndexOnCurrentThread(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        if (job != null) {
            job.run();
        }
    }

    private IndexSamplingJob createSamplingJob(IndexMap indexMap, long indexId) {
        IndexProxy proxy = indexMap.getIndexProxy(indexId);
        if (proxy == null || proxy.getState() != InternalIndexState.ONLINE) {
            return null;
        }
        return this.jobFactory.create(indexId, proxy);
    }

    public void start() {
        if (this.backgroundSampling) {
            Runnable samplingRunner = () -> this.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
            this.backgroundSamplingHandle = this.scheduler.scheduleRecurring(Group.INDEX_SAMPLING, samplingRunner, 10L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.backgroundSamplingHandle != null) {
            this.backgroundSamplingHandle.cancel(true);
        }
        this.jobTracker.stopAndAwaitAllJobs();
    }

    private static class IndexSamplingJobHandle {
        final IndexSamplingJob indexSamplingJob;
        final JobHandle jobHandle;

        IndexSamplingJobHandle(IndexSamplingJob indexSamplingJob, JobHandle jobHandle) {
            this.indexSamplingJob = indexSamplingJob;
            this.jobHandle = jobHandle;
        }
    }

    public static interface RecoveryCondition {
        public boolean test(StoreIndexDescriptor var1);
    }
}

