/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;

public class WebURLAccessRule
implements URLAccessRule {
    public static void checkNotBlocked(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        for (IPAddressString blockedIpRange : blockedIpRanges) {
            if (!blockedIpRange.contains(new IPAddressString(inetAddress.getHostAddress()))) continue;
            throw new URLAccessValidationError("access to " + inetAddress + " is blocked via the configuration property " + GraphDatabaseSettings.cypher_ip_blocklist.name());
        }
    }

    private static URL checkUrlIncludingHoops(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        boolean isRedirect;
        URL result = url;
        do {
            WebURLAccessRule.checkNotBlocked(result, blockedIpRanges);
            HttpURLConnection con = (HttpURLConnection)result.openConnection();
            con.setInstanceFollowRedirects(false);
            con.connect();
            con.getInputStream();
            boolean bl = isRedirect = con.getResponseCode() >= 300 && con.getResponseCode() < 400;
            if (isRedirect) {
                String location = con.getHeaderField("Location");
                if (location == null) {
                    throw new IOException("URL responded with a redirect but the location header was null");
                }
                if (location.startsWith("/")) {
                    location = result.getProtocol() + "://" + result.getAuthority() + location;
                }
                result = new URL(location);
            }
            con.disconnect();
        } while (isRedirect);
        return result;
    }

    public URL validate(Configuration config, URL url) throws URLAccessValidationError {
        List blockedIpRanges = (List)config.get(GraphDatabaseSettings.cypher_ip_blocklist);
        String host = url.getHost();
        if (!blockedIpRanges.isEmpty() && host != null && !host.isEmpty()) {
            try {
                WebURLAccessRule.checkUrlIncludingHoops(url, blockedIpRanges);
            }
            catch (Exception e) {
                throw new URLAccessValidationError("Unable to verify access to " + host + ". Cause: " + e.getMessage());
            }
        }
        return url;
    }
}

