/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class LoggingMonitor
implements IndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(StoreIndexDescriptor descriptor, String action, Exception cause) {
        this.log.error("Failed to open index:" + descriptor.getId() + ". " + action, (Throwable)cause);
    }

    @Override
    public void recoveryCleanupRegistered(File indexFile, IndexDescriptor indexDescriptor) {
        this.log.info("Schema index cleanup job registered: " + this.indexDescription(indexFile, indexDescriptor));
    }

    @Override
    public void recoveryCleanupStarted(File indexFile, IndexDescriptor indexDescriptor) {
        this.log.info("Schema index cleanup job started: " + this.indexDescription(indexFile, indexDescriptor));
    }

    @Override
    public void recoveryCleanupFinished(File indexFile, IndexDescriptor indexDescriptor, long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index cleanup job finished: " + this.indexDescription(indexFile, indexDescriptor) + " ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration(durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed(File indexFile, IndexDescriptor indexDescriptor) {
        this.log.info("Schema index cleanup job closed: " + this.indexDescription(indexFile, indexDescriptor));
    }

    @Override
    public void recoveryCleanupFailed(File indexFile, IndexDescriptor indexDescriptor, Throwable throwable) {
        this.log.info(String.format("Schema index cleanup job failed: %s.%nCaused by: %s", this.indexDescription(indexFile, indexDescriptor), ExceptionUtils.getStackTrace((Throwable)throwable)));
    }

    private String indexDescription(File indexFile, IndexDescriptor indexDescriptor) {
        return "descriptor=" + indexDescriptor.toString() + ", indexFile=" + indexFile.getAbsolutePath();
    }
}

