/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.io.File;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Legacy SSL policy settings")
public class LegacySslPolicyConfig
implements LoadableConfig {
    public static final String LEGACY_POLICY_NAME = "legacy";
    @Description(value="Directory for storing certificates to be used by Neo4j for TLS connections")
    public static final Setting<File> certificates_directory = Settings.pathSetting("dbms.directories.certificates", "certificates");
    @Internal
    @Description(value="Path to the X.509 public certificate to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_certificate_file = Settings.derivedSetting("unsupported.dbms.security.tls_certificate_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.cert"), Settings.PATH);
    @Internal
    @Description(value="Path to the X.509 private key to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_key_file = Settings.derivedSetting("unsupported.dbms.security.tls_key_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.key"), Settings.PATH);
}

