/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TransactionHooks {
    protected final Set<TransactionHook> hooks = new CopyOnWriteArraySet<TransactionHook>();

    public void register(TransactionHook hook) {
        this.hooks.add(hook);
    }

    public void unregister(TransactionHook hook) {
        this.hooks.remove(hook);
    }

    public TransactionHooksState beforeCommit(ReadableTransactionState state, KernelTransaction tx, StorageReader storageReader) {
        if (this.hooks.size() == 0) {
            return null;
        }
        TransactionHooksState hookState = new TransactionHooksState();
        for (TransactionHook hook : this.hooks) {
            Object outcome = hook.beforeCommit(state, tx, storageReader);
            hookState.add(hook, (TransactionHook.Outcome)outcome);
        }
        return hookState;
    }

    public void afterCommit(ReadableTransactionState state, KernelTransaction tx, TransactionHooksState hooksState) {
        if (hooksState == null) {
            return;
        }
        for (Pair<TransactionHook, TransactionHook.Outcome> hookAndOutcome : hooksState.hooksWithOutcome()) {
            TransactionHook hook = (TransactionHook)hookAndOutcome.first();
            TransactionHook.Outcome outcome = (TransactionHook.Outcome)hookAndOutcome.other();
            hook.afterCommit(state, tx, outcome);
        }
    }

    public void afterRollback(ReadableTransactionState state, KernelTransaction tx, TransactionHooksState hooksState) {
        if (hooksState == null) {
            return;
        }
        for (Pair<TransactionHook, TransactionHook.Outcome> hookAndOutcome : hooksState.hooksWithOutcome()) {
            ((TransactionHook)hookAndOutcome.first()).afterRollback(state, tx, (TransactionHook.Outcome)hookAndOutcome.other());
        }
    }

    public static class TransactionHooksState {
        private final List<Pair<TransactionHook, TransactionHook.Outcome>> hooksWithAttachment = new ArrayList<Pair<TransactionHook, TransactionHook.Outcome>>();
        private Throwable failure;

        public void add(TransactionHook hook, TransactionHook.Outcome outcome) {
            this.hooksWithAttachment.add((Pair<TransactionHook, TransactionHook.Outcome>)Pair.of((Object)hook, (Object)outcome));
            if (outcome != null && !outcome.isSuccessful()) {
                this.failure = outcome.failure();
            }
        }

        Iterable<Pair<TransactionHook, TransactionHook.Outcome>> hooksWithOutcome() {
            return this.hooksWithAttachment;
        }

        public boolean failed() {
            return this.failure != null;
        }

        public Throwable failure() {
            return this.failure;
        }
    }
}

