/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.Consumer;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public interface IndexProviderMap {
    public static final IndexProviderMap EMPTY = new IndexProviderMap(){

        @Override
        public IndexProvider lookup(IndexProviderDescriptor descriptor) throws IndexProviderNotFoundException {
            return IndexProvider.EMPTY;
        }

        @Override
        public IndexProvider lookup(String providerDescriptorName) throws IndexProviderNotFoundException {
            return IndexProvider.EMPTY;
        }

        @Override
        public IndexProvider getDefaultProvider() {
            return IndexProvider.EMPTY;
        }

        @Override
        public void accept(Consumer<IndexProvider> visitor) {
        }
    };

    public IndexProvider lookup(IndexProviderDescriptor var1) throws IndexProviderNotFoundException;

    public IndexProvider lookup(String var1) throws IndexProviderNotFoundException;

    public IndexProvider getDefaultProvider();

    public void accept(Consumer<IndexProvider> var1);

    default public CapableIndexDescriptor withCapabilities(StoreIndexDescriptor descriptor) {
        IndexProviderDescriptor providerDescriptor = descriptor.providerDescriptor();
        IndexCapability capability = this.lookup(providerDescriptor).getCapability(descriptor);
        return new CapableIndexDescriptor(descriptor, capability);
    }
}

