/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;

public class MergingBlockEntryReader<KEY, VALUE>
implements BlockEntryCursor<KEY, VALUE> {
    private final PriorityQueue<BlockEntryCursor<KEY, VALUE>> sortedReaders;
    private final List<BlockEntryCursor<KEY, VALUE>> readersToClose = new ArrayList<BlockEntryCursor<KEY, VALUE>>();
    private BlockEntryCursor<KEY, VALUE> lastReturned;

    MergingBlockEntryReader(Layout<KEY, VALUE> layout) {
        this.sortedReaders = new PriorityQueue((o1, o2) -> layout.compare(o1.key(), o2.key()));
    }

    void addSource(BlockEntryCursor<KEY, VALUE> source) throws IOException {
        this.readersToClose.add(source);
        if (source.next()) {
            this.sortedReaders.add(source);
        }
    }

    @Override
    public boolean next() throws IOException {
        if (this.lastReturned != null && this.lastReturned.next()) {
            this.sortedReaders.add(this.lastReturned);
        }
        if (this.sortedReaders.isEmpty()) {
            return false;
        }
        this.lastReturned = this.sortedReaders.poll();
        return true;
    }

    @Override
    public KEY key() {
        return this.lastReturned.key();
    }

    @Override
    public VALUE value() {
        return this.lastReturned.value();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.readersToClose);
    }
}

