/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.ReadableChannelPageCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.util.concurrent.Runnables;

public abstract class SimpleEntryStorage<ENTRY, CURSOR>
implements Closeable {
    static final int TYPE_SIZE = 1;
    static final byte STOP_TYPE = -1;
    private static final byte[] NO_ENTRIES = new byte[]{-1};
    private final File file;
    private final FileSystemAbstraction fs;
    private final int blockSize;
    private final ByteBufferFactory byteBufferFactory;
    private boolean allocated;
    private ByteBuffer buffer;
    private ByteArrayPageCursor pageCursor;
    private StoreChannel storeChannel;
    private volatile long count;

    SimpleEntryStorage(FileSystemAbstraction fs, File file, ByteBufferFactory byteBufferFactory, int blockSize) throws IOException {
        this.fs = fs;
        this.file = file;
        this.byteBufferFactory = byteBufferFactory;
        this.blockSize = blockSize;
    }

    void add(ENTRY entry) throws IOException {
        this.allocateResources();
        this.add(entry, (PageCursor)this.pageCursor);
        ++this.count;
    }

    CURSOR reader() throws IOException {
        if (!this.allocated) {
            return this.reader((PageCursor)new ByteArrayPageCursor(NO_ENTRIES));
        }
        ReadAheadChannel<StoreChannel> channel = new ReadAheadChannel<StoreChannel>(this.fs.open(this.file, OpenMode.READ), this.byteBufferFactory.newBuffer(this.blockSize));
        ReadableChannelPageCursor pageCursor = new ReadableChannelPageCursor(channel);
        return this.reader(pageCursor);
    }

    long count() {
        return this.count;
    }

    void doneAdding() throws IOException {
        if (!this.allocated) {
            return;
        }
        if (this.buffer.remaining() < 1) {
            this.flush();
        }
        this.pageCursor.putByte((byte)-1);
        this.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.allocated) {
            Runnables.runAll((String)("Failed while trying to close " + this.getClass().getSimpleName()), (Runnable[])new Runnable[]{() -> IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.pageCursor, this.storeChannel}), () -> this.fs.deleteFile(this.file)});
        } else {
            this.fs.deleteFile(this.file);
        }
    }

    abstract void add(ENTRY var1, PageCursor var2) throws IOException;

    abstract CURSOR reader(PageCursor var1) throws IOException;

    void prepareWrite(int entrySize) throws IOException {
        if (entrySize > this.buffer.remaining()) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.buffer.flip();
        this.storeChannel.write(this.buffer);
        this.buffer.clear();
    }

    private void allocateResources() throws IOException {
        if (!this.allocated) {
            this.buffer = this.byteBufferFactory.newBuffer(this.blockSize);
            this.pageCursor = new ByteArrayPageCursor(this.buffer);
            this.storeChannel = this.fs.create(this.file);
            this.allocated = true;
        }
    }
}

